package performance

import (
	"context"
	"database/sql"

	"github.com/zeromicro/go-zero/core/stores/sqlx"
)

var _ XPerformanceItemCommentModel = (*customXPerformanceItemCommentModel)(nil)

type (
	// XPerformanceItemCommentModel is an interface to be customized, add more methods here,
	// and implement the added methods in customXPerformanceItemCommentModel.
	XPerformanceItemCommentModel interface {
		xPerformanceItemCommentModel
		withSession(session sqlx.Session) XPerformanceItemCommentModel

		// 自定义
		XInsert(ctx context.Context, data *XPerformanceItemComment) (sql.Result, error)
		XFindOne(ctx context.Context, id uint64) (*XPerformanceItemComment, error)
		XUpdate(ctx context.Context, data *XPerformanceItemComment) error
		XDelete(ctx context.Context, id uint64) error
		TransInsertCtx(ctx context.Context, session sqlx.Session, data *XPerformanceItemComment) (sql.Result, error)
		TransUpdateCtx(ctx context.Context, session sqlx.Session, data *XPerformanceItemComment) error
		TransDeleteCtx(ctx context.Context, session sqlx.Session, id uint64) error
		TransCtx(ctx context.Context, fn func(ctx context.Context, s sqlx.Session) error) error
		TransMultiDeleteCtx(ctx context.Context, session sqlx.Session, ids []uint64) error

		FindByPerformanceItem(ctx context.Context, performanceId, itemId uint64, commentType uint32) (PerformanceItemCommentList, error)
		FindByPerformance(ctx context.Context, performanceId uint64) (PerformanceItemCommentList, error)
		PageByPerformanceItem(ctx context.Context, req PageByPerformanceItemReq) (PerformanceItemCommentList, error)
	}

	customXPerformanceItemCommentModel struct {
		*defaultXPerformanceItemCommentModel
	}
)

// NewXPerformanceItemCommentModel returns a model for the database table.
func NewXPerformanceItemCommentModel(conn sqlx.SqlConn) XPerformanceItemCommentModel {
	return &customXPerformanceItemCommentModel{
		defaultXPerformanceItemCommentModel: newXPerformanceItemCommentModel(conn),
	}
}

func (m *customXPerformanceItemCommentModel) withSession(session sqlx.Session) XPerformanceItemCommentModel {
	return NewXPerformanceItemCommentModel(sqlx.NewSqlConnFromSession(session))
}
