// Code generated by goctl. DO NOT EDIT.
// versions:
//  goctl version: 1.8.1

package performance

import (
	"context"
	"database/sql"
	"fmt"
	"strings"
	"time"

	"github.com/zeromicro/go-zero/core/stores/builder"
	"github.com/zeromicro/go-zero/core/stores/sqlx"
	"github.com/zeromicro/go-zero/core/stringx"
)

var (
	xPerformanceItemCommentFieldNames          = builder.RawFieldNames(&XPerformanceItemComment{})
	xPerformanceItemCommentRows                = strings.Join(xPerformanceItemCommentFieldNames, ",")
	xPerformanceItemCommentRowsExpectAutoSet   = strings.Join(stringx.Remove(xPerformanceItemCommentFieldNames, "`id`", "`create_at`", "`create_time`", "`created_at`", "`update_at`", "`update_time`", "`updated_at`"), ",")
	xPerformanceItemCommentRowsWithPlaceHolder = strings.Join(stringx.Remove(xPerformanceItemCommentFieldNames, "`id`", "`create_at`", "`create_time`", "`created_at`", "`update_at`", "`update_time`", "`updated_at`"), "=?,") + "=?"
)

type (
	xPerformanceItemCommentModel interface {
		Insert(ctx context.Context, data *XPerformanceItemComment) (sql.Result, error)
		FindOne(ctx context.Context, id uint64) (*XPerformanceItemComment, error)
		Update(ctx context.Context, data *XPerformanceItemComment) error
		Delete(ctx context.Context, id uint64) error
	}

	defaultXPerformanceItemCommentModel struct {
		conn  sqlx.SqlConn
		table string
	}

	XPerformanceItemComment struct {
		Id            uint64       `db:"id"`             // 主键ID
		PerformanceId uint64       `db:"performance_id"` // 绩效ID
		ItemId        uint64       `db:"item_id"`        // 项目ID
		CommentType   uint64       `db:"comment_type"`   // 评论类型 1: 工作项, 2: 附加项
		UserEmail     string       `db:"user_email"`     // 评论发布者
		Comment       string       `db:"comment"`        // 评论内容
		CreatedAt     time.Time    `db:"created_at"`     // 创建时间
		UpdatedAt     time.Time    `db:"updated_at"`     // 更新时间
		DeletedAt     sql.NullTime `db:"deleted_at"`     // 删除时间
	}
)

func newXPerformanceItemCommentModel(conn sqlx.SqlConn) *defaultXPerformanceItemCommentModel {
	return &defaultXPerformanceItemCommentModel{
		conn:  conn,
		table: "`x_performance_item_comment`",
	}
}

func (m *defaultXPerformanceItemCommentModel) Delete(ctx context.Context, id uint64) error {
	query := fmt.Sprintf("delete from %s where `id` = ?", m.table)
	_, err := m.conn.ExecCtx(ctx, query, id)
	return err
}

func (m *defaultXPerformanceItemCommentModel) FindOne(ctx context.Context, id uint64) (*XPerformanceItemComment, error) {
	query := fmt.Sprintf("select %s from %s where `id` = ? limit 1", xPerformanceItemCommentRows, m.table)
	var resp XPerformanceItemComment
	err := m.conn.QueryRowCtx(ctx, &resp, query, id)
	switch err {
	case nil:
		return &resp, nil
	case sqlx.ErrNotFound:
		return nil, ErrNotFound
	default:
		return nil, err
	}
}

func (m *defaultXPerformanceItemCommentModel) Insert(ctx context.Context, data *XPerformanceItemComment) (sql.Result, error) {
	query := fmt.Sprintf("insert into %s (%s) values (?, ?, ?, ?, ?, ?)", m.table, xPerformanceItemCommentRowsExpectAutoSet)
	ret, err := m.conn.ExecCtx(ctx, query, data.PerformanceId, data.ItemId, data.CommentType, data.UserEmail, data.Comment, data.DeletedAt)
	return ret, err
}

func (m *defaultXPerformanceItemCommentModel) Update(ctx context.Context, data *XPerformanceItemComment) error {
	query := fmt.Sprintf("update %s set %s where `id` = ?", m.table, xPerformanceItemCommentRowsWithPlaceHolder)
	_, err := m.conn.ExecCtx(ctx, query, data.PerformanceId, data.ItemId, data.CommentType, data.UserEmail, data.Comment, data.DeletedAt, data.Id)
	return err
}

func (m *defaultXPerformanceItemCommentModel) tableName() string {
	return m.table
}
