package performance

import (
	"context"
	"database/sql"

	"github.com/zeromicro/go-zero/core/stores/sqlx"
)

var _ XPerformanceModel = (*customXPerformanceModel)(nil)

type (
	// XPerformanceModel is an interface to be customized, add more methods here,
	// and implement the added methods in customXPerformanceModel.
	XPerformanceModel interface {
		xPerformanceModel
		withSession(session sqlx.Session) XPerformanceModel

		// 自定义
		XInsert(ctx context.Context, data *XPerformance) (sql.Result, error)
		XFindOne(ctx context.Context, id uint64) (*XPerformance, error)
		XFindOneByIds(ctx context.Context, ids []uint64) ([]*XPerformance, error)
		XUpdate(ctx context.Context, data *XPerformance) error
		XDelete(ctx context.Context, id uint64) error
		TransInsertCtx(ctx context.Context, session sqlx.Session, data *XPerformance) (sql.Result, error)
		TransUpdateCtx(ctx context.Context, session sqlx.Session, data *XPerformance) error
		TransDeleteCtx(ctx context.Context, session sqlx.Session, id uint64) error
		TransCtx(ctx context.Context, fn func(ctx context.Context, s sqlx.Session) error) error

		GetOneByUserAndTime(ctx context.Context, email string, year, monthNum uint64) (*XPerformance, error)
		GetOne(ctx context.Context, email string, year, monthNum uint64, isExcellentEmployee uint64) (*XPerformance, error)
		FindByUserAndTime(ctx context.Context, userEmail string, year, month_num uint64) (PerformanceList, error)
		FindAllByTime(ctx context.Context, req FindAllByTimeQuery) (PerformanceList, error)
		FindAllByUserAndTime(ctx context.Context, req FindAllByUserAndTimeQuery) (PerformanceList, error)
		UpdatePerformanceBonus(ctx context.Context, req UpdatePerformanceBonusQuery) error
		CountByUserAndTime(ctx context.Context, emails []string, year, monthNum uint64, isExcellentEmployee uint64, status uint64) (*RankingCountData, error)
		CountByTime(ctx context.Context, year, monthNum uint64) (*RankingCountData, error)
		UpdatePerformanceStatus(ctx context.Context, req UpdatePerformanceStatusQuery) error
	}

	customXPerformanceModel struct {
		*defaultXPerformanceModel
	}
)

// NewXPerformanceModel returns a model for the database table.
func NewXPerformanceModel(conn sqlx.SqlConn) XPerformanceModel {
	return &customXPerformanceModel{
		defaultXPerformanceModel: newXPerformanceModel(conn),
	}
}

func (m *customXPerformanceModel) withSession(session sqlx.Session) XPerformanceModel {
	return NewXPerformanceModel(sqlx.NewSqlConnFromSession(session))
}
