// Code generated by goctl. DO NOT EDIT.
// versions:
//  goctl version: 1.8.1

package performance

import (
	"context"
	"database/sql"
	"fmt"
	"strings"
	"time"

	"github.com/zeromicro/go-zero/core/stores/builder"
	"github.com/zeromicro/go-zero/core/stores/sqlx"
	"github.com/zeromicro/go-zero/core/stringx"
)

var (
	xPerformanceFieldNames          = builder.RawFieldNames(&XPerformance{})
	xPerformanceRows                = strings.Join(xPerformanceFieldNames, ",")
	xPerformanceRowsExpectAutoSet   = strings.Join(stringx.Remove(xPerformanceFieldNames, "`id`", "`create_at`", "`create_time`", "`created_at`", "`update_at`", "`update_time`", "`updated_at`"), ",")
	xPerformanceRowsWithPlaceHolder = strings.Join(stringx.Remove(xPerformanceFieldNames, "`id`", "`create_at`", "`create_time`", "`created_at`", "`update_at`", "`update_time`", "`updated_at`"), "=?,") + "=?"
)

type (
	xPerformanceModel interface {
		Insert(ctx context.Context, data *XPerformance) (sql.Result, error)
		FindOne(ctx context.Context, id uint64) (*XPerformance, error)
		Update(ctx context.Context, data *XPerformance) error
		Delete(ctx context.Context, id uint64) error
	}

	defaultXPerformanceModel struct {
		conn  sqlx.SqlConn
		table string
	}

	XPerformance struct {
		Id                      uint64       `db:"id"`                        // 主键ID
		UserEmail               string       `db:"user_email"`                // 用户邮箱
		LeaderEmail             string       `db:"leader_email"`              // 上级邮箱
		Year                    uint64       `db:"year"`                      // 绩效所属年度
		MonthNum                uint64       `db:"month_num"`                 // 双月编号,7:年度绩效,1:第一个双月, 2: 第二双月...
		WorkItemWeight          float64      `db:"work_item_weight"`          // 工作项权重和
		AdditionItemWeight      float64      `db:"addition_item_weight"`      // 附加项权重和
		TotalScore              float64      `db:"total_score"`               // 绩效总分
		LeaderWords             string       `db:"leader_words"`              // 上级评价
		Status                  uint64       `db:"status"`                    // 状态, 1:员工自评 2: 上级评价, 3:待员工确认, 4: 绩效确认 5: 结束（待提交）, 6: 其他同事评价，50，待确认 51，已确认
		TimeFactor              float64      `db:"time_factor"`               // 绩效时间系数
		Level                   string       `db:"level"`                     // 绩效等级
		LevelFactor             float64      `db:"level_factor"`              // 绩效等级系数
		IncidentDeduction       float64      `db:"incident_deduction"`        // 生产事故扣减
		ExcellentMemberBonus    float64      `db:"excellent_member_bonus"`    // 优秀组员激励
		ExcellentManagerBonus   float64      `db:"excellent_manager_bonus"`   // 优秀管理激励
		ProjectBonus            float64      `db:"project_bonus"`             // 项目激励
		TotalBonus              float64      `db:"total_bonus"`               // 绩效发放金额
		IsExcellentEmployee     uint64       `db:"is_excellent_employee"`     // 是否是优秀员工：1,不是 2，是
		ExcellentEmployeeReason string       `db:"excellent_employee_reason"` // 提名原因
		CreatedAt               time.Time    `db:"created_at"`                // 创建时间
		UpdatedAt               time.Time    `db:"updated_at"`                // 更新时间
		DeletedAt               sql.NullTime `db:"deleted_at"`                // 删除时间
	}
)

func newXPerformanceModel(conn sqlx.SqlConn) *defaultXPerformanceModel {
	return &defaultXPerformanceModel{
		conn:  conn,
		table: "`x_performance`",
	}
}

func (m *defaultXPerformanceModel) Delete(ctx context.Context, id uint64) error {
	query := fmt.Sprintf("delete from %s where `id` = ?", m.table)
	_, err := m.conn.ExecCtx(ctx, query, id)
	return err
}

func (m *defaultXPerformanceModel) FindOne(ctx context.Context, id uint64) (*XPerformance, error) {
	query := fmt.Sprintf("select %s from %s where `id` = ? limit 1", xPerformanceRows, m.table)
	var resp XPerformance
	err := m.conn.QueryRowCtx(ctx, &resp, query, id)
	switch err {
	case nil:
		return &resp, nil
	case sqlx.ErrNotFound:
		return nil, ErrNotFound
	default:
		return nil, err
	}
}

func (m *defaultXPerformanceModel) Insert(ctx context.Context, data *XPerformance) (sql.Result, error) {
	query := fmt.Sprintf("insert into %s (%s) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", m.table, xPerformanceRowsExpectAutoSet)
	ret, err := m.conn.ExecCtx(ctx, query, data.UserEmail, data.LeaderEmail, data.Year, data.MonthNum, data.WorkItemWeight, data.AdditionItemWeight, data.TotalScore, data.LeaderWords, data.Status, data.TimeFactor, data.Level, data.LevelFactor, data.IncidentDeduction, data.ExcellentMemberBonus, data.ExcellentManagerBonus, data.ProjectBonus, data.TotalBonus, data.IsExcellentEmployee, data.ExcellentEmployeeReason, data.DeletedAt)
	return ret, err
}

func (m *defaultXPerformanceModel) Update(ctx context.Context, data *XPerformance) error {
	query := fmt.Sprintf("update %s set %s where `id` = ?", m.table, xPerformanceRowsWithPlaceHolder)
	_, err := m.conn.ExecCtx(ctx, query, data.UserEmail, data.LeaderEmail, data.Year, data.MonthNum, data.WorkItemWeight, data.AdditionItemWeight, data.TotalScore, data.LeaderWords, data.Status, data.TimeFactor, data.Level, data.LevelFactor, data.IncidentDeduction, data.ExcellentMemberBonus, data.ExcellentManagerBonus, data.ProjectBonus, data.TotalBonus, data.IsExcellentEmployee, data.ExcellentEmployeeReason, data.DeletedAt, data.Id)
	return err
}

func (m *defaultXPerformanceModel) tableName() string {
	return m.table
}
