package performance

import (
	"context"
	"database/sql"

	"github.com/zeromicro/go-zero/core/stores/sqlx"
)

var _ XPerformanceWorkModel = (*customXPerformanceWorkModel)(nil)

type (
	// XPerformanceWorkModel is an interface to be customized, add more methods here,
	// and implement the added methods in customXPerformanceWorkModel.
	XPerformanceWorkModel interface {
		xPerformanceWorkModel
		withSession(session sqlx.Session) XPerformanceWorkModel

		// 自定义
		XInsert(ctx context.Context, data *XPerformanceWork) (sql.Result, error)
		XFindOne(ctx context.Context, id uint64) (*XPerformanceWork, error)
		XUpdate(ctx context.Context, data *XPerformanceWork) error
		XDelete(ctx context.Context, id uint64) error
		TransInsertCtx(ctx context.Context, session sqlx.Session, data *XPerformanceWork) (sql.Result, error)
		TransUpdateCtx(ctx context.Context, session sqlx.Session, data *XPerformanceWork) error
		TransDeleteCtx(ctx context.Context, session sqlx.Session, id uint64) error
		TransCtx(ctx context.Context, fn func(ctx context.Context, s sqlx.Session) error) error

		GetWorkItemsByPerformanceId(ctx context.Context, performanceId uint64) (PerformanceWorkItemList, error)
		TransGetWorkItemsByPerformanceId(ctx context.Context, session sqlx.Session, performanceId uint64) (PerformanceWorkItemList, error)
		GetWorkItemsByPerformanceIds(ctx context.Context, performanceIds []uint64) (PerformanceWorkItemList, error)
	}

	customXPerformanceWorkModel struct {
		*defaultXPerformanceWorkModel
	}
)

// NewXPerformanceWorkModel returns a model for the database table.
func NewXPerformanceWorkModel(conn sqlx.SqlConn) XPerformanceWorkModel {
	return &customXPerformanceWorkModel{
		defaultXPerformanceWorkModel: newXPerformanceWorkModel(conn),
	}
}

func (m *customXPerformanceWorkModel) withSession(session sqlx.Session) XPerformanceWorkModel {
	return NewXPerformanceWorkModel(sqlx.NewSqlConnFromSession(session))
}
