// Code generated by goctl. DO NOT EDIT.
// versions:
//  goctl version: 1.8.1

package performance

import (
	"context"
	"database/sql"
	"fmt"
	"strings"
	"time"

	"github.com/zeromicro/go-zero/core/stores/builder"
	"github.com/zeromicro/go-zero/core/stores/sqlx"
	"github.com/zeromicro/go-zero/core/stringx"
)

var (
	xPerformanceWorkFieldNames          = builder.RawFieldNames(&XPerformanceWork{})
	xPerformanceWorkRows                = strings.Join(xPerformanceWorkFieldNames, ",")
	xPerformanceWorkRowsExpectAutoSet   = strings.Join(stringx.Remove(xPerformanceWorkFieldNames, "`id`", "`create_at`", "`create_time`", "`created_at`", "`update_at`", "`update_time`", "`updated_at`"), ",")
	xPerformanceWorkRowsWithPlaceHolder = strings.Join(stringx.Remove(xPerformanceWorkFieldNames, "`id`", "`create_at`", "`create_time`", "`created_at`", "`update_at`", "`update_time`", "`updated_at`"), "=?,") + "=?"
)

type (
	xPerformanceWorkModel interface {
		Insert(ctx context.Context, data *XPerformanceWork) (sql.Result, error)
		FindOne(ctx context.Context, id uint64) (*XPerformanceWork, error)
		Update(ctx context.Context, data *XPerformanceWork) error
		Delete(ctx context.Context, id uint64) error
	}

	defaultXPerformanceWorkModel struct {
		conn  sqlx.SqlConn
		table string
	}

	XPerformanceWork struct {
		Id             uint64       `db:"id"`              // 主键ID
		PerformanceId  uint64       `db:"performance_id"`  // 绩效ID
		ItemName       string       `db:"item_name"`       // 工作项名称
		ItemWeight     float64      `db:"item_weight"`     // 权重
		ItemDesc       string       `db:"item_desc"`       // 工作项描述
		ItemDeficiency string       `db:"item_deficiency"` // 不足之处
		SelfScore      float64      `db:"self_score"`      // 自评分
		LeaderScore    float64      `db:"leader_score"`    // 上级自评分
		CreatedAt      time.Time    `db:"created_at"`      // 创建时间
		UpdatedAt      time.Time    `db:"updated_at"`      // 更新时间
		DeletedAt      sql.NullTime `db:"deleted_at"`      // 删除时间
	}
)

func newXPerformanceWorkModel(conn sqlx.SqlConn) *defaultXPerformanceWorkModel {
	return &defaultXPerformanceWorkModel{
		conn:  conn,
		table: "`x_performance_work`",
	}
}

func (m *defaultXPerformanceWorkModel) Delete(ctx context.Context, id uint64) error {
	query := fmt.Sprintf("delete from %s where `id` = ?", m.table)
	_, err := m.conn.ExecCtx(ctx, query, id)
	return err
}

func (m *defaultXPerformanceWorkModel) FindOne(ctx context.Context, id uint64) (*XPerformanceWork, error) {
	query := fmt.Sprintf("select %s from %s where `id` = ? limit 1", xPerformanceWorkRows, m.table)
	var resp XPerformanceWork
	err := m.conn.QueryRowCtx(ctx, &resp, query, id)
	switch err {
	case nil:
		return &resp, nil
	case sqlx.ErrNotFound:
		return nil, ErrNotFound
	default:
		return nil, err
	}
}

func (m *defaultXPerformanceWorkModel) Insert(ctx context.Context, data *XPerformanceWork) (sql.Result, error) {
	query := fmt.Sprintf("insert into %s (%s) values (?, ?, ?, ?, ?, ?, ?, ?)", m.table, xPerformanceWorkRowsExpectAutoSet)
	ret, err := m.conn.ExecCtx(ctx, query, data.PerformanceId, data.ItemName, data.ItemWeight, data.ItemDesc, data.ItemDeficiency, data.SelfScore, data.LeaderScore, data.DeletedAt)
	return ret, err
}

func (m *defaultXPerformanceWorkModel) Update(ctx context.Context, data *XPerformanceWork) error {
	query := fmt.Sprintf("update %s set %s where `id` = ?", m.table, xPerformanceWorkRowsWithPlaceHolder)
	_, err := m.conn.ExecCtx(ctx, query, data.PerformanceId, data.ItemName, data.ItemWeight, data.ItemDesc, data.ItemDeficiency, data.SelfScore, data.LeaderScore, data.DeletedAt, data.Id)
	return err
}

func (m *defaultXPerformanceWorkModel) tableName() string {
	return m.table
}
