package report

import (
	"context"
	"fmt"
	"strings"
)

func (m *customXReportCommentModel) FindByReportIds(ctx context.Context, reportIds []uint64) (ReportCommentList, error) {
	if len(reportIds) == 0 {
		return nil, nil
	}
	placeholders := make([]string, len(reportIds))
	args := make([]any, len(reportIds))
	for i, v := range reportIds {
		placeholders[i] = "?"
		args[i] = v
	}

	query := fmt.Sprintf("select * from %s where `report_id` in (%s) order by id asc", m.table, strings.Join(placeholders, ", "))
	var list ReportCommentList
	err := m.conn.QueryRowsCtx(ctx, &list, query, args...)
	return list, err
}

type ReportCommentList []*XReportComment

func (l ReportCommentList) ByReportId() map[uint64]ReportCommentList {
	m := make(map[uint64]ReportCommentList)
	for _, v := range l {
		if _, ok := m[v.ReportId]; !ok {
			m[v.ReportId] = ReportCommentList{v}
			continue
		}
		m[v.ReportId] = append(m[v.ReportId], v)
	}

	return m
}
