package report

import (
	"context"
	"database/sql"
	"fmt"
	"time"

	"github.com/zeromicro/go-zero/core/stores/sqlx"
)

func (m *customXReportMentionModel) TransCtx(ctx context.Context, fn func(ctx context.Context, s sqlx.Session) error) error {
	return m.conn.TransactCtx(ctx, func(ctx context.Context, s sqlx.Session) error {
		return fn(ctx, s)
	})
}

func (m *customXReportMentionModel) TransDeleteCtx(ctx context.Context, session sqlx.Session, id uint64) error {
	query := fmt.Sprintf("delete from %s where `id` = ?", m.table)
	_, err := session.ExecCtx(ctx, query, id)
	return err
}

func (m *customXReportMentionModel) TransDeleteByReportIdCtx(ctx context.Context, session sqlx.Session, reportId uint64) error {
	query := fmt.Sprintf("delete from %s where `report_id` = ?", m.table)
	_, err := session.ExecCtx(ctx, query, reportId)
	return err
}

func (m *customXReportMentionModel) TransInsertCtx(ctx context.Context, session sqlx.Session, data *XReportMention) (sql.Result, error) {
	query := fmt.Sprintf("insert into %s (%s) values (?, ?, ?, ?, ?, ?)", m.table, xReportMentionRowsExpectAutoSet)
	ret, err := session.ExecCtx(ctx, query, data.ReportId, data.ReportType, data.ReportDate, data.ReportItemId, data.InitiatorEmail, data.MentionUserEmail)
	return ret, err
}

func (m *customXReportMentionModel) TransUpdateCtx(ctx context.Context, session sqlx.Session, data *XReportMention) error {
	query := fmt.Sprintf("update %s set %s where `id` = ?", m.table, xReportMentionRowsWithPlaceHolder)
	_, err := session.ExecCtx(ctx, query, data.ReportId, data.ReportType, data.ReportDate, data.ReportItemId, data.InitiatorEmail, data.MentionUserEmail, data.Id)
	return err
}

type FindUserReportMentionReq struct {
	UserEmail       string
	TargetUserEmail string
	ReportStartDate time.Time
	ReportEndDate   time.Time
}

func (m *customXReportMentionModel) FindUserReportMention(ctx context.Context, req FindUserReportMentionReq) (ReportMentionList, error) {
	query := fmt.Sprintf(`select * from %s 
	where 
		report_item_id in (
			select distinct(report_item_id) from %s 
			where 
			report_date >= ? and report_date <= ? 
			and 
			(initiator_email = ? or mention_user_email = ?)
		)`, m.table, m.table)
	var list ReportMentionList
	err := m.conn.QueryRowsCtx(ctx, &list, query, req.ReportStartDate, req.ReportEndDate, req.TargetUserEmail, req.TargetUserEmail)
	return list, err
}

type ReportMentionList []*XReportMention

func (l ReportMentionList) ByReportItemId() map[uint64]ReportMentionList {
	m := make(map[uint64]ReportMentionList)
	for _, v := range l {
		if _, ok := m[v.ReportItemId]; !ok {
			m[v.ReportItemId] = ReportMentionList{v}
			continue
		}
		m[v.ReportItemId] = append(m[v.ReportItemId], v)
	}

	return m
}
func (l ReportMentionList) ReportItemIds() []uint64 {
	var ids []uint64
	set := make(map[uint64]struct{})
	for _, v := range l {
		if _, ok := set[v.ReportItemId]; !ok {
			ids = append(ids, v.ReportItemId)
		}
	}
	return ids
}
