package report

import (
	"context"

	"github.com/zeromicro/go-zero/core/stores/sqlx"
)

var _ XReportCommentModel = (*customXReportCommentModel)(nil)

type (
	// XReportCommentModel is an interface to be customized, add more methods here,
	// and implement the added methods in customXReportCommentModel.
	XReportCommentModel interface {
		xReportCommentModel
		withSession(session sqlx.Session) XReportCommentModel

		// 自定义
		FindByReportIds(ctx context.Context, reportIds []uint64) (ReportCommentList, error)
	}

	customXReportCommentModel struct {
		*defaultXReportCommentModel
	}
)

// NewXReportCommentModel returns a model for the database table.
func NewXReportCommentModel(conn sqlx.SqlConn) XReportCommentModel {
	return &customXReportCommentModel{
		defaultXReportCommentModel: newXReportCommentModel(conn),
	}
}

func (m *customXReportCommentModel) withSession(session sqlx.Session) XReportCommentModel {
	return NewXReportCommentModel(sqlx.NewSqlConnFromSession(session))
}
