// Code generated by goctl. DO NOT EDIT.
// versions:
//  goctl version: 1.8.1

package report

import (
	"context"
	"database/sql"
	"fmt"
	"strings"
	"time"

	"github.com/zeromicro/go-zero/core/stores/builder"
	"github.com/zeromicro/go-zero/core/stores/sqlx"
	"github.com/zeromicro/go-zero/core/stringx"
)

var (
	xReportCommentFieldNames          = builder.RawFieldNames(&XReportComment{})
	xReportCommentRows                = strings.Join(xReportCommentFieldNames, ",")
	xReportCommentRowsExpectAutoSet   = strings.Join(stringx.Remove(xReportCommentFieldNames, "`id`", "`create_at`", "`create_time`", "`created_at`", "`update_at`", "`update_time`", "`updated_at`"), ",")
	xReportCommentRowsWithPlaceHolder = strings.Join(stringx.Remove(xReportCommentFieldNames, "`id`", "`create_at`", "`create_time`", "`created_at`", "`update_at`", "`update_time`", "`updated_at`"), "=?,") + "=?"
)

type (
	xReportCommentModel interface {
		Insert(ctx context.Context, data *XReportComment) (sql.Result, error)
		FindOne(ctx context.Context, id uint64) (*XReportComment, error)
		Update(ctx context.Context, data *XReportComment) error
		Delete(ctx context.Context, id uint64) error
	}

	defaultXReportCommentModel struct {
		conn  sqlx.SqlConn
		table string
	}

	XReportComment struct {
		Id        uint64    `db:"id"`         // 主键ID
		ReportId  uint64    `db:"report_id"`  // 汇报ID
		UserEmail string    `db:"user_email"` // 评论人email
		Content   string    `db:"content"`    // 评论内容
		CreatedAt time.Time `db:"created_at"` // 创建时间
		UpdatedAt time.Time `db:"updated_at"` // 更新时间
	}
)

func newXReportCommentModel(conn sqlx.SqlConn) *defaultXReportCommentModel {
	return &defaultXReportCommentModel{
		conn:  conn,
		table: "`x_report_comment`",
	}
}

func (m *defaultXReportCommentModel) Delete(ctx context.Context, id uint64) error {
	query := fmt.Sprintf("delete from %s where `id` = ?", m.table)
	_, err := m.conn.ExecCtx(ctx, query, id)
	return err
}

func (m *defaultXReportCommentModel) FindOne(ctx context.Context, id uint64) (*XReportComment, error) {
	query := fmt.Sprintf("select %s from %s where `id` = ? limit 1", xReportCommentRows, m.table)
	var resp XReportComment
	err := m.conn.QueryRowCtx(ctx, &resp, query, id)
	switch err {
	case nil:
		return &resp, nil
	case sqlx.ErrNotFound:
		return nil, ErrNotFound
	default:
		return nil, err
	}
}

func (m *defaultXReportCommentModel) Insert(ctx context.Context, data *XReportComment) (sql.Result, error) {
	query := fmt.Sprintf("insert into %s (%s) values (?, ?, ?)", m.table, xReportCommentRowsExpectAutoSet)
	ret, err := m.conn.ExecCtx(ctx, query, data.ReportId, data.UserEmail, data.Content)
	return ret, err
}

func (m *defaultXReportCommentModel) Update(ctx context.Context, data *XReportComment) error {
	query := fmt.Sprintf("update %s set %s where `id` = ?", m.table, xReportCommentRowsWithPlaceHolder)
	_, err := m.conn.ExecCtx(ctx, query, data.ReportId, data.UserEmail, data.Content, data.Id)
	return err
}

func (m *defaultXReportCommentModel) tableName() string {
	return m.table
}
