package report

import (
	"context"
	"database/sql"

	"github.com/zeromicro/go-zero/core/stores/sqlx"
)

var _ XReportItemModel = (*customXReportItemModel)(nil)

type (
	// XReportItemModel is an interface to be customized, add more methods here,
	// and implement the added methods in customXReportItemModel.
	XReportItemModel interface {
		xReportItemModel
		withSession(session sqlx.Session) XReportItemModel

		// 自定义方法
		TransCtx(ctx context.Context, fn func(ctx context.Context, s sqlx.Session) error) error
		TransDeleteCtx(ctx context.Context, session sqlx.Session, id uint64) error
		TransDeleteByReportIdCtx(ctx context.Context, session sqlx.Session, reportId uint64) error
		TransInsertCtx(ctx context.Context, session sqlx.Session, data *XReportItem) (sql.Result, error)
		TransUpdateCtx(ctx context.Context, session sqlx.Session, data *XReportItem) error
		FindByReportIds(ctx context.Context, reportIds []uint64) (ReportItemList, error)
		FindByIds(ctx context.Context, ids []uint64) (ReportItemList, error)
	}

	customXReportItemModel struct {
		*defaultXReportItemModel
	}
)

// NewXReportItemModel returns a model for the database table.
func NewXReportItemModel(conn sqlx.SqlConn) XReportItemModel {
	return &customXReportItemModel{
		defaultXReportItemModel: newXReportItemModel(conn),
	}
}

func (m *customXReportItemModel) withSession(session sqlx.Session) XReportItemModel {
	return NewXReportItemModel(sqlx.NewSqlConnFromSession(session))
}
