// Code generated by goctl. DO NOT EDIT.
// versions:
//  goctl version: 1.8.1

package report

import (
	"context"
	"database/sql"
	"fmt"
	"strings"
	"time"

	"github.com/zeromicro/go-zero/core/stores/builder"
	"github.com/zeromicro/go-zero/core/stores/sqlx"
	"github.com/zeromicro/go-zero/core/stringx"
)

var (
	xReportItemFieldNames          = builder.RawFieldNames(&XReportItem{})
	xReportItemRows                = strings.Join(xReportItemFieldNames, ",")
	xReportItemRowsExpectAutoSet   = strings.Join(stringx.Remove(xReportItemFieldNames, "`id`", "`create_at`", "`create_time`", "`created_at`", "`update_at`", "`update_time`", "`updated_at`"), ",")
	xReportItemRowsWithPlaceHolder = strings.Join(stringx.Remove(xReportItemFieldNames, "`id`", "`create_at`", "`create_time`", "`created_at`", "`update_at`", "`update_time`", "`updated_at`"), "=?,") + "=?"
)

type (
	xReportItemModel interface {
		Insert(ctx context.Context, data *XReportItem) (sql.Result, error)
		FindOne(ctx context.Context, id uint64) (*XReportItem, error)
		Update(ctx context.Context, data *XReportItem) error
		Delete(ctx context.Context, id uint64) error
	}

	defaultXReportItemModel struct {
		conn  sqlx.SqlConn
		table string
	}

	XReportItem struct {
		Id        uint64    `db:"id"`         // 主键ID
		ReportId  uint64    `db:"report_id"`  // 汇报ID
		Content   string    `db:"content"`    // 工作内容(富文本)
		CreatedAt time.Time `db:"created_at"` // 创建时间
		UpdatedAt time.Time `db:"updated_at"` // 更新时间
	}
)

func newXReportItemModel(conn sqlx.SqlConn) *defaultXReportItemModel {
	return &defaultXReportItemModel{
		conn:  conn,
		table: "`x_report_item`",
	}
}

func (m *defaultXReportItemModel) Delete(ctx context.Context, id uint64) error {
	query := fmt.Sprintf("delete from %s where `id` = ?", m.table)
	_, err := m.conn.ExecCtx(ctx, query, id)
	return err
}

func (m *defaultXReportItemModel) FindOne(ctx context.Context, id uint64) (*XReportItem, error) {
	query := fmt.Sprintf("select %s from %s where `id` = ? limit 1", xReportItemRows, m.table)
	var resp XReportItem
	err := m.conn.QueryRowCtx(ctx, &resp, query, id)
	switch err {
	case nil:
		return &resp, nil
	case sqlx.ErrNotFound:
		return nil, ErrNotFound
	default:
		return nil, err
	}
}

func (m *defaultXReportItemModel) Insert(ctx context.Context, data *XReportItem) (sql.Result, error) {
	query := fmt.Sprintf("insert into %s (%s) values (?, ?)", m.table, xReportItemRowsExpectAutoSet)
	ret, err := m.conn.ExecCtx(ctx, query, data.ReportId, data.Content)
	return ret, err
}

func (m *defaultXReportItemModel) Update(ctx context.Context, data *XReportItem) error {
	query := fmt.Sprintf("update %s set %s where `id` = ?", m.table, xReportItemRowsWithPlaceHolder)
	_, err := m.conn.ExecCtx(ctx, query, data.ReportId, data.Content, data.Id)
	return err
}

func (m *defaultXReportItemModel) tableName() string {
	return m.table
}
