package report

import (
	"context"
	"database/sql"

	"github.com/zeromicro/go-zero/core/stores/sqlx"
)

var _ XReportMentionModel = (*customXReportMentionModel)(nil)

type (
	// XReportMentionModel is an interface to be customized, add more methods here,
	// and implement the added methods in customXReportMentionModel.
	XReportMentionModel interface {
		xReportMentionModel
		withSession(session sqlx.Session) XReportMentionModel

		// 自定义方法
		TransCtx(ctx context.Context, fn func(ctx context.Context, s sqlx.Session) error) error
		TransDeleteCtx(ctx context.Context, session sqlx.Session, id uint64) error
		TransDeleteByReportIdCtx(ctx context.Context, session sqlx.Session, reportId uint64) error
		TransInsertCtx(ctx context.Context, session sqlx.Session, data *XReportMention) (sql.Result, error)
		TransUpdateCtx(ctx context.Context, session sqlx.Session, data *XReportMention) error
		FindUserReportMention(ctx context.Context, req FindUserReportMentionReq) (ReportMentionList, error)
	}

	customXReportMentionModel struct {
		*defaultXReportMentionModel
	}
)

// NewXReportMentionModel returns a model for the database table.
func NewXReportMentionModel(conn sqlx.SqlConn) XReportMentionModel {
	return &customXReportMentionModel{
		defaultXReportMentionModel: newXReportMentionModel(conn),
	}
}

func (m *customXReportMentionModel) withSession(session sqlx.Session) XReportMentionModel {
	return NewXReportMentionModel(sqlx.NewSqlConnFromSession(session))
}
