// Code generated by goctl. DO NOT EDIT.
// versions:
//  goctl version: 1.8.1

package report

import (
	"context"
	"database/sql"
	"fmt"
	"strings"
	"time"

	"github.com/zeromicro/go-zero/core/stores/builder"
	"github.com/zeromicro/go-zero/core/stores/sqlx"
	"github.com/zeromicro/go-zero/core/stringx"
)

var (
	xReportMentionFieldNames          = builder.RawFieldNames(&XReportMention{})
	xReportMentionRows                = strings.Join(xReportMentionFieldNames, ",")
	xReportMentionRowsExpectAutoSet   = strings.Join(stringx.Remove(xReportMentionFieldNames, "`id`", "`create_at`", "`create_time`", "`created_at`", "`update_at`", "`update_time`", "`updated_at`"), ",")
	xReportMentionRowsWithPlaceHolder = strings.Join(stringx.Remove(xReportMentionFieldNames, "`id`", "`create_at`", "`create_time`", "`created_at`", "`update_at`", "`update_time`", "`updated_at`"), "=?,") + "=?"
)

type (
	xReportMentionModel interface {
		Insert(ctx context.Context, data *XReportMention) (sql.Result, error)
		FindOne(ctx context.Context, id uint64) (*XReportMention, error)
		Update(ctx context.Context, data *XReportMention) error
		Delete(ctx context.Context, id uint64) error
	}

	defaultXReportMentionModel struct {
		conn  sqlx.SqlConn
		table string
	}

	XReportMention struct {
		Id               uint64    `db:"id"`                 // 主键ID
		ReportId         uint64    `db:"report_id"`          // 汇报ID
		ReportType       uint64    `db:"report_type"`        // 汇报类型(1:日报；2:周报；3:月报)
		ReportDate       time.Time `db:"report_date"`        // 汇报日期
		ReportItemId     uint64    `db:"report_item_id"`     // 汇报条目ID
		InitiatorEmail   string    `db:"initiator_email"`    // 提及发起人
		MentionUserEmail string    `db:"mention_user_email"` // 被提及人
		CreatedAt        time.Time `db:"created_at"`         // 创建时间
		UpdatedAt        time.Time `db:"updated_at"`         // 更新时间
	}
)

func newXReportMentionModel(conn sqlx.SqlConn) *defaultXReportMentionModel {
	return &defaultXReportMentionModel{
		conn:  conn,
		table: "`x_report_mention`",
	}
}

func (m *defaultXReportMentionModel) Delete(ctx context.Context, id uint64) error {
	query := fmt.Sprintf("delete from %s where `id` = ?", m.table)
	_, err := m.conn.ExecCtx(ctx, query, id)
	return err
}

func (m *defaultXReportMentionModel) FindOne(ctx context.Context, id uint64) (*XReportMention, error) {
	query := fmt.Sprintf("select %s from %s where `id` = ? limit 1", xReportMentionRows, m.table)
	var resp XReportMention
	err := m.conn.QueryRowCtx(ctx, &resp, query, id)
	switch err {
	case nil:
		return &resp, nil
	case sqlx.ErrNotFound:
		return nil, ErrNotFound
	default:
		return nil, err
	}
}

func (m *defaultXReportMentionModel) Insert(ctx context.Context, data *XReportMention) (sql.Result, error) {
	query := fmt.Sprintf("insert into %s (%s) values (?, ?, ?, ?, ?, ?)", m.table, xReportMentionRowsExpectAutoSet)
	ret, err := m.conn.ExecCtx(ctx, query, data.ReportId, data.ReportType, data.ReportDate, data.ReportItemId, data.InitiatorEmail, data.MentionUserEmail)
	return ret, err
}

func (m *defaultXReportMentionModel) Update(ctx context.Context, data *XReportMention) error {
	query := fmt.Sprintf("update %s set %s where `id` = ?", m.table, xReportMentionRowsWithPlaceHolder)
	_, err := m.conn.ExecCtx(ctx, query, data.ReportId, data.ReportType, data.ReportDate, data.ReportItemId, data.InitiatorEmail, data.MentionUserEmail, data.Id)
	return err
}

func (m *defaultXReportMentionModel) tableName() string {
	return m.table
}
