package report

import (
	"context"
	"database/sql"
	"time"

	"github.com/zeromicro/go-zero/core/stores/sqlx"
)

var _ XReportModel = (*customXReportModel)(nil)

type (
	// XReportModel is an interface to be customized, add more methods here,
	// and implement the added methods in customXReportModel.
	XReportModel interface {
		xReportModel
		withSession(session sqlx.Session) XReportModel

		//自定义方法
		TransCtx(ctx context.Context, fn func(ctx context.Context, s sqlx.Session) error) error
		TransInsertCtx(ctx context.Context, session sqlx.Session, data *XReport) (sql.Result, error)
		TransUpdateCtx(ctx context.Context, session sqlx.Session, newData *XReport) error
		FindUserReports(ctx context.Context, req FindUserReportsReq) (int64, ReportList, error)
		FindUserLatestDelayAndRisk(ctx context.Context, req FindUserLatestDelayAndRiskReq) (ReportList, error)
		FindReportsByUserAndReportStartDate(ctx context.Context, reportStartDate time.Time, users []string) (ReportList, error)
		FindDepartmentReports(ctx context.Context, req FindDepartmentReportsReq) (ReportList, error)
		GetReportCountByUserAndType(ctx context.Context, userEmails []string, dateFrom, dateTo string) (list []*XReportCountByUserAndType, err error)
		GetReportCountByUserAndDate(ctx context.Context, userEmails []string, dateFrom, dateTo string) (list []*XReportCountByUserAndDate, err error)
	}

	customXReportModel struct {
		*defaultXReportModel
	}
)

// NewXReportModel returns a model for the database table.
func NewXReportModel(conn sqlx.SqlConn) XReportModel {
	return &customXReportModel{
		defaultXReportModel: newXReportModel(conn),
	}
}

func (m *customXReportModel) withSession(session sqlx.Session) XReportModel {
	return NewXReportModel(sqlx.NewSqlConnFromSession(session))
}

type XReportCountByUserAndType struct {
	UserEmail  string `db:"user_email"`  // 创建人email
	ReportType string `db:"report_type"` // 汇报类型(1:日报；2:周报；3:月报)
	Count      int    `db:"count"`
}

type XReportCountByUserAndDate struct {
	UserEmail  string `db:"user_email"`  // 创建人email
	ReportDate string `db:"report_date"` // 汇报日期
	Count      int    `db:"count"`
}
