// Code generated by goctl. DO NOT EDIT.
// versions:
//  goctl version: 1.8.1

package report

import (
	"context"
	"database/sql"
	"fmt"
	"strings"
	"time"

	"github.com/zeromicro/go-zero/core/stores/builder"
	"github.com/zeromicro/go-zero/core/stores/sqlx"
	"github.com/zeromicro/go-zero/core/stringx"
)

var (
	xReportFieldNames          = builder.RawFieldNames(&XReport{})
	xReportRows                = strings.Join(xReportFieldNames, ",")
	xReportRowsExpectAutoSet   = strings.Join(stringx.Remove(xReportFieldNames, "`id`", "`create_at`", "`create_time`", "`created_at`", "`update_at`", "`update_time`", "`updated_at`"), ",")
	xReportRowsWithPlaceHolder = strings.Join(stringx.Remove(xReportFieldNames, "`id`", "`create_at`", "`create_time`", "`created_at`", "`update_at`", "`update_time`", "`updated_at`"), "=?,") + "=?"
)

type (
	xReportModel interface {
		Insert(ctx context.Context, data *XReport) (sql.Result, error)
		FindOne(ctx context.Context, id uint64) (*XReport, error)
		FindOneByUserEmailReportDateReportType(ctx context.Context, userEmail string, reportDate time.Time, reportType uint64) (*XReport, error)
		Update(ctx context.Context, data *XReport) error
		Delete(ctx context.Context, id uint64) error
	}

	defaultXReportModel struct {
		conn  sqlx.SqlConn
		table string
	}

	XReport struct {
		Id          uint64    `db:"id"`           // 主键ID
		UserEmail   string    `db:"user_email"`   // 创建人email
		ReportType  uint64    `db:"report_type"`  // 汇报类型(1:日报；2:周报；3:月报)
		ReportDate  time.Time `db:"report_date"`  // 汇报日期
		IsDelayed   int64     `db:"is_delayed"`   // 是否延期(0:无, 1:有)
		DelayReason string    `db:"delay_reason"` // 延期原因
		HasRisk     int64     `db:"has_risk"`     // 是否有风险(0:无, 1:有)
		RiskDesc    string    `db:"risk_desc"`    // 风险描述
		Status      uint64    `db:"status"`       // 状态(1:草稿 2:完成)
		CreatedAt   time.Time `db:"created_at"`   // 创建时间
		UpdatedAt   time.Time `db:"updated_at"`   // 更新时间
	}
)

func newXReportModel(conn sqlx.SqlConn) *defaultXReportModel {
	return &defaultXReportModel{
		conn:  conn,
		table: "`x_report`",
	}
}

func (m *defaultXReportModel) Delete(ctx context.Context, id uint64) error {
	query := fmt.Sprintf("delete from %s where `id` = ?", m.table)
	_, err := m.conn.ExecCtx(ctx, query, id)
	return err
}

func (m *defaultXReportModel) FindOne(ctx context.Context, id uint64) (*XReport, error) {
	query := fmt.Sprintf("select %s from %s where `id` = ? limit 1", xReportRows, m.table)
	var resp XReport
	err := m.conn.QueryRowCtx(ctx, &resp, query, id)
	switch err {
	case nil:
		return &resp, nil
	case sqlx.ErrNotFound:
		return nil, ErrNotFound
	default:
		return nil, err
	}
}

func (m *defaultXReportModel) FindOneByUserEmailReportDateReportType(ctx context.Context, userEmail string, reportDate time.Time, reportType uint64) (*XReport, error) {
	var resp XReport
	query := fmt.Sprintf("select %s from %s where `user_email` = ? and `report_date` = ? and `report_type` = ? limit 1", xReportRows, m.table)
	err := m.conn.QueryRowCtx(ctx, &resp, query, userEmail, reportDate, reportType)
	switch err {
	case nil:
		return &resp, nil
	case sqlx.ErrNotFound:
		return nil, ErrNotFound
	default:
		return nil, err
	}
}

func (m *defaultXReportModel) Insert(ctx context.Context, data *XReport) (sql.Result, error) {
	query := fmt.Sprintf("insert into %s (%s) values (?, ?, ?, ?, ?, ?, ?, ?)", m.table, xReportRowsExpectAutoSet)
	ret, err := m.conn.ExecCtx(ctx, query, data.UserEmail, data.ReportType, data.ReportDate, data.IsDelayed, data.DelayReason, data.HasRisk, data.RiskDesc, data.Status)
	return ret, err
}

func (m *defaultXReportModel) Update(ctx context.Context, newData *XReport) error {
	query := fmt.Sprintf("update %s set %s where `id` = ?", m.table, xReportRowsWithPlaceHolder)
	_, err := m.conn.ExecCtx(ctx, query, newData.UserEmail, newData.ReportType, newData.ReportDate, newData.IsDelayed, newData.DelayReason, newData.HasRisk, newData.RiskDesc, newData.Status, newData.Id)
	return err
}

func (m *defaultXReportModel) tableName() string {
	return m.table
}
