CREATE TABLE IF NOT EXISTS `x_issues` (
                            `id` bigint NOT NULL AUTO_INCREMENT COMMENT '主键',
                            `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '标题',
                            `content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '内容',
                            `severity` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '严重程度',
                            `status` int NOT NULL DEFAULT '0' COMMENT '流程状态',
                            `process_pos` int NOT NULL DEFAULT '0' COMMENT '当前流程位置',
                            `process_id` int NOT NULL DEFAULT '0' COMMENT '当前处理流程id',
                            `process_status` int NOT NULL DEFAULT '0' COMMENT '当前处理状态',
                            `assigned_to` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '分配给',
                            `reporter` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '提交人',
                            `tester` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '负责测试',
                            `developer` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '负责研发',
                            `product_manager` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '负责产品',
                            `process_approver` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '当前d',
                            `process_approver_code` int NOT NULL DEFAULT '0' COMMENT '当前处理角色',
                            `affected_version` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '影响版本',
                            `fix_version` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '修复版本',
                            `attachments` longblob NOT NULL COMMENT '附件',
                            `labels` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '标签',
                            `type` int NOT NULL DEFAULT '1' COMMENT '1: issue',
                            `create_at` int NOT NULL DEFAULT '0' COMMENT '创建时间',
                            `update_at` int NOT NULL DEFAULT '0' COMMENT '更新时间',
                            `is_deleted` int NOT NULL DEFAULT '0' COMMENT '0-1-',
                            `estimated_time` int NOT NULL DEFAULT '0' COMMENT '预计时间',
                            PRIMARY KEY (`id`),
                            KEY `idx_reporter` (`reporter`),
                            KEY `idx_process` (`process_approver`)
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='问题记录表';

-- ----------------------------
-- Table structure for x_issues_process
-- ----------------------------
CREATE TABLE IF NOT EXISTS `x_issues_process` (
                                    `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT '对象Id',
                                    `issue_id` int NOT NULL DEFAULT '0' COMMENT 'issue id',
                                    `pos` bigint NOT NULL DEFAULT '0' COMMENT '流程当前步骤',
                                    `approver` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '处理人',
                                    `attachments` longblob NOT NULL COMMENT '附件',
                                    `approver_code` int NOT NULL DEFAULT '0' COMMENT '处理人类型 1 开发 2 开发组长 3 测试 4 测试组长 5 运维 6 项目发布 100 流程结束',
                                    `status` int NOT NULL DEFAULT '0' COMMENT '流程状态',
                                    `process_handler` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '流程处理人',
                                    `remark` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '处理备注',
                                    `tag` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '标签',
                                    `create_at` int NOT NULL DEFAULT '0' COMMENT '创建时间',
                                    `update_at` int NOT NULL DEFAULT '0' COMMENT '更新时间',
                                    `estimated_time` int NOT NULL DEFAULT '0',
                                    PRIMARY KEY (`id`),
                                    KEY `idx_status` (`status`),
                                    KEY `idx_issid` (`issue_id`),
                                    KEY `idx_approver` (`approver`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=181 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='问题状态流转表';

CREATE TABLE IF NOT EXISTS `x_okr` (
                         `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT '主键id',
                         `year_str` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '年度',
                         `quarter_str` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '季度',
                         `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '创建人',
                         `result` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '结果',
                         `target` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '目标',
                         `create_at` int NOT NULL DEFAULT '0' COMMENT '创建时间',
                         `update_at` int NOT NULL DEFAULT '0' COMMENT '更新时间',
                         PRIMARY KEY (`id`),
                         KEY `idx_email` (`creator`),
                         KEY `idx_year` (`year_str`)
) ENGINE=InnoDB AUTO_INCREMENT=44 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
