
-- ----------------------------
-- Table structure for x_performance
-- ----------------------------
CREATE TABLE IF NOT EXISTS `x_performance` (
                                 `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT '主键ID',
                                 `user_email` varchar(50) NOT NULL DEFAULT '' COMMENT '用户邮箱',
                                 `leader_email` varchar(50) NOT NULL DEFAULT '' COMMENT '上级邮箱',
                                 `year` smallint unsigned NOT NULL DEFAULT '0' COMMENT '绩效所属年度',
                                 `month_num` tinyint unsigned NOT NULL DEFAULT '0' COMMENT '双月编号,7:年度绩效,1:第一个双月, 2: 第二双月...',
                                 `total_score` decimal(5,2) NOT NULL DEFAULT '0.00' COMMENT '绩效总分',
                                 `leader_words` varchar(2048) NOT NULL DEFAULT '' COMMENT '上级评价',
                                 `status` tinyint unsigned NOT NULL DEFAULT '1' COMMENT '状态, 1:员工自评 2: 上级评价, 3:待员工确认, 4: 员工拒绝, 5: 待上级确认, 6: 上级拒绝, 7: 结束',
                                 `time_factor` decimal(4,2) NOT NULL DEFAULT '0.00' COMMENT '绩效时间系数',
                                 `level` varchar(5) NOT NULL DEFAULT '' COMMENT '绩效等级',
                                 `level_factor` decimal(4,2) NOT NULL DEFAULT '0.00' COMMENT '绩效等级系数',
                                 `incident_deduction` decimal(9,2) NOT NULL DEFAULT '0.00' COMMENT '生产事故扣减',
                                 `excellent_member_bonus` decimal(9,2) NOT NULL DEFAULT '0.00' COMMENT '优秀组员激励',
                                 `excellent_manager_bonus` decimal(9,2) NOT NULL DEFAULT '0.00' COMMENT '优秀管理激励',
                                 `total_bonus` decimal(9,2) NOT NULL DEFAULT '0.00' COMMENT '绩效发放金额',
                                 `created_at` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) COMMENT '创建时间',
                                 `updated_at` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3) COMMENT '更新时间',
                                 `deleted_at` datetime(3) DEFAULT NULL COMMENT '删除时间',
                                 PRIMARY KEY (`id`),
                                 KEY `idx_user_email_year_month_num` (`user_email`,`year`,`month_num`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Table structure for x_performance_addition
-- ----------------------------
CREATE TABLE IF NOT EXISTS `x_performance_addition` (
                                          `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT '主键ID',
                                          `performance_id` bigint unsigned NOT NULL DEFAULT '0' COMMENT '绩效ID',
                                          `item_name` varchar(255) NOT NULL DEFAULT '' COMMENT '附加项名称',
                                          `item_type` tinyint unsigned NOT NULL DEFAULT '0' COMMENT '附加项类型 1：行为及态度指标 2: 管理能力指 3: 附加规则',
                                          `item_weight` decimal(5,2) NOT NULL DEFAULT '0.00' COMMENT '权重',
                                          `item_desc` varchar(2048) NOT NULL DEFAULT '' COMMENT '附加项具体描述',
                                          `coworker_email` varchar(50) NOT NULL DEFAULT '' COMMENT '其他部门评价人',
                                          `self_score` decimal(5,2) NOT NULL DEFAULT '0.00' COMMENT '自评分',
                                          `leader_score` decimal(5,2) NOT NULL DEFAULT '0.00' COMMENT '上级评分',
                                          `created_at` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) COMMENT '创建时间',
                                          `updated_at` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3) COMMENT '更新时间',
                                          `deleted_at` datetime(3) DEFAULT NULL COMMENT '删除时间',
                                          PRIMARY KEY (`id`),
                                          KEY `idx_performance_id` (`performance_id`)
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Table structure for x_performance_item_comment
-- ----------------------------
CREATE TABLE IF NOT EXISTS `x_performance_item_comment` (
                                              `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT '主键ID',
                                              `performance_id` bigint unsigned NOT NULL DEFAULT '0' COMMENT '绩效ID',
                                              `item_id` bigint unsigned NOT NULL DEFAULT '0' COMMENT '项目ID',
                                              `comment_type` tinyint unsigned NOT NULL DEFAULT '0' COMMENT '评论类型 1: 工作项, 2: 附加项',
                                              `user_email` varchar(50) NOT NULL DEFAULT '' COMMENT '评论发布者',
                                              `comment` varchar(500) NOT NULL DEFAULT '' COMMENT '评论内容',
                                              `created_at` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) COMMENT '创建时间',
                                              `updated_at` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3) COMMENT '更新时间',
                                              `deleted_at` datetime(3) DEFAULT NULL COMMENT '删除时间',
                                              PRIMARY KEY (`id`),
                                              KEY `idx_preformance_id_item_id_item_type` (`performance_id`,`item_id`,`comment_type`)
) ENGINE=InnoDB AUTO_INCREMENT=55 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Table structure for x_performance_work
-- ----------------------------
CREATE TABLE IF NOT EXISTS `x_performance_work` (
                                      `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT '主键ID',
                                      `performance_id` bigint unsigned NOT NULL DEFAULT '0' COMMENT '绩效ID',
                                      `item_name` varchar(255) NOT NULL DEFAULT '' COMMENT '工作项名称',
                                      `item_weight` decimal(5,2) NOT NULL DEFAULT '0.00' COMMENT '权重',
                                      `item_desc` varchar(2048) NOT NULL DEFAULT '' COMMENT '工作项描述',
                                      `item_deficiency` varchar(2048) NOT NULL DEFAULT '' COMMENT '不足之处',
                                      `self_score` decimal(5,2) NOT NULL DEFAULT '0.00' COMMENT '自评分',
                                      `leader_score` decimal(5,2) NOT NULL DEFAULT '0.00' COMMENT '上级自评分',
                                      `created_at` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) COMMENT '创建时间',
                                      `updated_at` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3) COMMENT '更新时间',
                                      `deleted_at` datetime(3) DEFAULT NULL COMMENT '删除时间',
                                      PRIMARY KEY (`id`),
                                      KEY `idx_performance_id` (`performance_id`)
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Table structure for x_review
-- ----------------------------
CREATE TABLE IF NOT EXISTS `x_review` (
                            `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT '主键id',
                            `level` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '故障定级',
                            `issue_id` int unsigned NOT NULL COMMENT 'issue_id',
                            `scope` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '影响范围',
                            `review` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '回顾',
                            `root_cause` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '故障根因',
                            `scheme` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '修复方案',
                            `improvement` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '改进方案',
                            `kpi` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '关联绩效',
                            `remark` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '备注',
                            `owner` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '创建人',
                            `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间\n',
                            `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
                            `responsible` varchar(255) COLLATE utf8mb4_general_ci NOT NULL COMMENT '负责人',
                            `handler` varchar(255) COLLATE utf8mb4_general_ci NOT NULL COMMENT '处理人',
                            PRIMARY KEY (`id`),
                            KEY `idx_owner` (`owner`),
                            KEY `idx_level` (`level`),
                            KEY `idx_iid` (`issue_id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Table structure for x_review_user
-- ----------------------------
CREATE TABLE IF NOT EXISTS `x_review_user` (
                                 `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '用户email',
                                 `rid` int unsigned NOT NULL COMMENT 'review_id',
                                 UNIQUE KEY `udx_er` (`email`,`rid`) COMMENT '关注',
                                 KEY `idx_rid` (`rid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Table structure for x_user_follow_issue
-- ----------------------------
CREATE TABLE IF NOT EXISTS `x_user_follow_issue` (
                                       `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT '主键id',
                                       `email` varchar(255) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
                                       `issue_id` int unsigned NOT NULL DEFAULT '0',
                                       PRIMARY KEY (`id`),
                                       KEY `udx_e_i` (`email`,`issue_id`) COMMENT '用户关注的issue'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='用户关注issue';