CREATE TABLE IF NOT EXISTS `x_report` (
    `id` bigint unsigned AUTO_INCREMENT PRIMARY KEY COMMENT '主键ID',
    `user_email` varchar(150) NOT NULL DEFAULT '' COMMENT '创建人email',
    `report_type` tinyint unsigned NOT NULL DEFAULT 0 COMMENT '汇报类型(1:日报；2:周报；3:月报)',
    `report_date` date DEFAULT NULL COMMENT '汇报日期',
    `is_delayed` tinyint(1) NOT NULL DEFAULT 0 COMMENT '是否延期(0:无, 1:有)',
    `delay_reason` varchar(255) NOT NULL DEFAULT '' COMMENT '延期原因',
    `has_risk` tinyint(1) NOT NULL DEFAULT 0 COMMENT '是否有风险(0:无, 1:有)',
    `risk_desc` varchar(255) NOT NULL DEFAULT '' COMMENT '风险描述',
    `status` tinyint unsigned NOT NULL DEFAULT 0 COMMENT '状态(1:草稿 2:完成)',
    `created_at` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) COMMENT '创建时间',
    `updated_at` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3) COMMENT '更新时间',
     UNIQUE KEY `uk_user_daily` (`user_email`, `report_date`, `report_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='工作汇报主表';

CREATE TABLE IF NOT EXISTS `x_report_item`(
    `id` bigint unsigned NOT NULL AUTO_INCREMENT PRIMARY KEY COMMENT '主键ID',
    `report_id` bigint unsigned NOT NULL DEFAULT 0 COMMENT '汇报ID',
    `content` text NOT NULL COMMENT '工作内容(富文本)',
    `created_at` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) COMMENT '创建时间',
    `updated_at` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3) COMMENT '更新时间',
    KEY `idx_report_id` (`report_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='汇报条目表';

CREATE TABLE IF NOT EXISTS `x_report_mention` (
    `id` bigint unsigned NOT NULL AUTO_INCREMENT PRIMARY KEY COMMENT '主键ID',
    `report_id` bigint unsigned NOT NULL DEFAULT 0 COMMENT '汇报ID',
    `report_type` tinyint unsigned NOT NULL DEFAULT 0 COMMENT '汇报类型(1:日报；2:周报；3:月报)',
    `report_date` date DEFAULT NULL COMMENT '汇报日期',
    `report_item_id` bigint unsigned NOT NULL DEFAULT 0 COMMENT '汇报条目ID',
    `initiator_email` varchar(150) NOT NULL DEFAULT '' COMMENT '提及发起人',
    `mention_user_email` varchar(150) NOT NULL DEFAULT '' COMMENT '被提及人',
    `created_at` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) COMMENT '创建时间',
    `updated_at` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3) COMMENT '更新时间',
    KEY `idx_report_date_initiator_email` (`report_date`,`initiator_email`),
    KEY `idx_report_date_mention_user_email` (`report_date`,`mention_user_email`),
    KEY `idx_report_item_id` (`report_item_id`)
)ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='汇报条目提及表';

CREATE TABLE IF NOT EXISTS `x_report_comment` (
    `id` bigint unsigned NOT NULL AUTO_INCREMENT PRIMARY KEY COMMENT '主键ID',
    `report_id` bigint unsigned NOT NULL DEFAULT 0 COMMENT '汇报ID',
    `user_email` varchar(150) NOT NULL DEFAULT '' COMMENT '评论人email',
    `content` varchar(255) NOT NULL DEFAULT '' COMMENT '评论内容',
    `created_at` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) COMMENT '创建时间',
    `updated_at` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3) COMMENT '更新时间',
    KEY `IDX_report_id` (`report_id`)
)ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='汇报评论表';