CREATE TABLE IF NOT EXISTS `x_performance_addition_score` (
    `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT '主键ID',
    `performance_id` bigint unsigned NOT NULL DEFAULT '0' COMMENT '绩效ID',
    `item_id` bigint NOT NULL DEFAULT '0' COMMENT '项目ID',
    `year` smallint unsigned NOT NULL DEFAULT '0' COMMENT '绩效所属年度',
    `score` decimal(5,2) NOT NULL DEFAULT '0.00' COMMENT '其他部门同事的评分',
    `month_num` tinyint unsigned NOT NULL DEFAULT '0' COMMENT '双月编号,7:年度绩效,1:第一个双月, 2: 第二双月...',
    `user_email` varchar(255)  NOT NULL DEFAULT '' COMMENT '被评价同事姓名',
    `status` tinyint NOT NULL DEFAULT '1' COMMENT '状态：1，未评分 2，已提交',
    `item_desc` varchar(2048) NOT NULL DEFAULT '' COMMENT '其他部门同事对当前同事的评价内容',
    `coworker_email` varchar(255) NOT NULL DEFAULT '' COMMENT '其他部门评价人',
    `created_at` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) COMMENT '创建时间',
    `updated_at` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3) COMMENT '更新时间',
     PRIMARY KEY (`id`),
    KEY `idx_year_month_num_coworker_email` (`year`,`month_num`,`coworker_email`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='环评表';