create table IF NOT EXISTS x_okr_period
(
    period_id              bigint auto_increment comment '周期id',
    owner                  varchar(255) not null comment '用户',
    start_date             date         not null comment '周期开始时间',
    end_date               date         not null comment '周期结束时间',
    owner_department_keys  varchar(255) not null comment '用户所在部门key列表【纯冗余】',
    owner_department_names varchar(255) not null comment '用户所在部门name列表【纯冗余】',
    approval_status        integer      not null comment '确认状态枚举: 1未确认，2待确认，3已确认',
    `created_at`           datetime(3)  not null default current_timestamp(3) comment '创建时间',
    `updated_at`           datetime(3)  not null default current_timestamp(3) on update current_timestamp(3) comment '更新时间',
    primary key (`period_id`) using btree,
    unique key unique_owner_start_end (owner, start_date, end_date)
) engine = innodb
  default charset = utf8mb4 comment ='用户的okr周期';

create table IF NOT EXISTS x_o_kr_task
(
    entity_id        bigint auto_increment comment 'o/kr/task的id',
    entity_type      integer       not null comment '类型枚举: o1，kr2，task3',
    parent_entity_id bigint        not null comment '父节点entity_id',
    period_id        bigint        not null comment 'okr周期id',
    content          text          not null comment '内容',
    priority         integer       not null comment '优先级',
    deadline         date          not null comment 'entity截止日期',
    type_for_kr      integer       not null comment 'kr类型枚举: 1承诺型、2挑战型，默认为承诺型',
    owner            varchar(255)  not null comment '负责人 【冗余的， 由本记录的period_id决定】',
    position         integer       not null comment '在负责人视图中的元素序号',
    weight           decimal(5, 2) not null default 0 not null comment '在负责人视图中的元素权重',
    intended_owner   varchar(255)  not null comment '领导尝试将这个条目分配给哪个下属(仅申请未批复时为非空)',
    `created_at`     datetime(3)   not null default current_timestamp(3) comment '创建时间',
    `updated_at`     datetime(3)   not null default current_timestamp(3) on update current_timestamp(3) comment '更新时间',
    primary key (`entity_id`) using btree,
    KEY `idx_period_id` (`period_id`)
) engine = innodb
  default charset = utf8mb4 comment ='owner的o/kr/task 树';

create table IF NOT EXISTS x_okr_alignment
(
    id                  bigint auto_increment comment 'id',
    entity_id           bigint        not null comment '下属的entity',
    align_with_entity   bigint        not null comment '领导的entity',
    align_with_user     varchar(255)  not null comment '被对齐条目的负责人（领导）【冗余的， 由x_alignment表记录的align_with_entity字段决定】',
    align_with_position integer       not null comment '在领导视图中的元素序号',
    align_with_weight   decimal(5, 2) not null comment '在领导视图中的元素权重',
    intended            integer       not null comment '下属尝试将这个条目对齐到某个领导的条目: 0:已批复同意对齐 1:仅申请未批复',
    by_assign           integer       not null comment '对齐关系是否由领导的分配动作产生: 0:否 1:是',
    `created_at`        datetime(3)   not null default current_timestamp(3) comment '创建时间',
    `updated_at`        datetime(3)   not null default current_timestamp(3) on update current_timestamp(3) comment '更新时间',
    primary key (`id`) using btree,
    unique key (entity_id, align_with_entity)
) engine = innodb
  default charset = utf8mb4 comment ='下属的entity和领导的某entity对齐';

create table IF NOT EXISTS x_okr_msg
(
    id              bigint auto_increment comment 'id',
    from_user       varchar(255) not null comment '发消息人',
    to_user         varchar(255) not null comment '收消息人',
    type            integer      not null comment '消息类型：1:对齐Req 2:对齐Resp 3:分配Req 4:分配Resp 5:确认Req 6:确认Resp', 
    content         text         not null comment '详情json {"entity_id":10,...} 具体处理方式在content里，因 Type 而异',
    approval_status integer      not null comment '处理方式枚举: 1:未处理 2:已处理',
    start_date      date         not null comment '冗余的okr周期开始时间',
    end_date        date         not null comment '冗余的okr周期结束时间',
    `created_at`    datetime(3)  not null default current_timestamp(3) comment '创建时间(发消息时间)',
    `updated_at`    datetime(3)  not null default current_timestamp(3) on update current_timestamp(3) comment '更新时间',
    primary key (`id`) using btree
) engine = innodb
  default charset = utf8mb4 comment ='okr协作消息表';

create table IF NOT EXISTS x_okr_operating_history
(
    id             bigint auto_increment,
    `table`        varchar(255) not null comment '表',
    pk             bigint       not null comment '行',
    operating_type varchar(255) not null comment '操作类型cud',
    old_value      text         not null comment '旧值',
    new_value      text         not null comment '新值',
    `user`         varchar(255) not null comment '操作人',
    `created_at`   datetime(3)  not null default current_timestamp(3) comment '创建时间（操作时间）',
    primary key (`id`) using btree
) engine = innodb
  default charset = utf8mb4 comment ='操作历史表';
