CREATE TABLE IF NOT EXISTS `x_department_language_info`  (
                                               `id` int NOT NULL AUTO_INCREMENT COMMENT 'id',
                                               `department_name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '部门多语言名称',
                                               `created_at` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) COMMENT '创建时间',
                                               `updated_at` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3) COMMENT '更新时间',
                                               PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 63 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '部门多语言表';



-- ----------------------------
-- Records of x_department_language_info
-- ----------------------------
INSERT INTO `x_department_language_info` (`department_name`) VALUES
                                                 ('{"zh-TW": "资产交易部", "en-US": "Asset Trading Department"}'),
                                                 ('{"zh-TW": "产品运营部", "en-US": "Product Operations Department"}'),
                                                 ('{"zh-TW": "区域业务", "en-US": "Regional Business"}'),
                                                 ('{"zh-TW": "研发部", "en-US": "R&D Department"}'),
                                                 ('{"zh-TW": "客服部", "en-US": "Customer Service Department"}'),
                                                 ('{"zh-TW": "产品部", "en-US": "Product Department"}'),
                                                 ('{"zh-TW": "人力行政部门", "en-US": "HR & Administration Department"}'),
                                                 ('{"zh-TW": "市场部", "en-US": "Marketing Department"}'),
                                                 ('{"zh-TW": "法币运营部", "en-US": "Fiat Operations Department"}'),
                                                 ('{"zh-TW": "现货业务", "en-US": "Spot Trading Business"}');

CREATE TABLE IF NOT EXISTS `x_position_info`  (
                                    `id` int NOT NULL AUTO_INCREMENT COMMENT 'id',
                                    `department_id` int NOT NULL DEFAULT 0 COMMENT '部门id',
                                    `email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '简历接收邮箱',
                                    `language` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '默认语言',
                                    `sort` int NULL DEFAULT 999 COMMENT '排序',
                                    `recruit_switch` TINYINT NOT NULL DEFAULT 0 COMMENT '招聘开关',
                                    `urgent_shortage` TINYINT NOT NULL DEFAULT 0 COMMENT '急缺职位',
                                    `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '创建人',
                                    `created_at` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) COMMENT '创建时间',
                                    `updated_at` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3) COMMENT '更新时间',
                                    PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 43 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '招聘信息表';

CREATE TABLE IF NOT EXISTS `x_position_language_info`  (
                                             `id` int NOT NULL AUTO_INCREMENT COMMENT 'id',
                                             `position_id` int NOT NULL DEFAULT 0 COMMENT '岗位信息id',
                                             `language` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '语言',
                                             `position_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '职位名称',
                                             `operating_duty` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '工作职责',
                                             `job_requirements` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '任职要求',
                                             `created_at` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) COMMENT '创建时间',
                                             `updated_at` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3) COMMENT '更新时间',
                                             PRIMARY KEY (`id`) USING BTREE,
                                             UNIQUE INDEX `udx_position_language`(`position_id` ASC, `language` ASC) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 43 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '招聘多语言信息表';

CREATE TABLE IF NOT EXISTS `x_deliver_record`  (
                                     `id` int NOT NULL AUTO_INCREMENT COMMENT 'id',
                                     `position_id` int NOT NULL DEFAULT 0 COMMENT '岗位信息id',
                                     `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '姓名',
                                     `email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '邮箱',
                                     `exchange_experience` TINYINT NOT NULL DEFAULT 0 COMMENT '是否有交易所经验',
                                     `web3_experience` TINYINT NOT NULL DEFAULT 0 COMMENT '是否有web3经验',
                                     `exchange_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '交易所名称',
                                     `web3_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'web3名称',
                                     `resume` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '简历/作品集',
                                     `created_at` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) COMMENT '创建时间',
                                     `updated_at` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3) COMMENT '更新时间',
                                     PRIMARY KEY (`id`) USING BTREE,
                                     INDEX `idx_posttionid`(`position_id` ASC) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 43 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '招聘投递记录表';
