package calc

import (
	"net/http"

	"oa-server/app/oacenter/oa_api/internal/logic/calc"
	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/response"
)

func CalcEnumHandler(svcCtx *svc.ServiceContext) http.HandlerFunc {
	return func(w http.ResponseWriter, r *http.Request) {
		l := calc.NewCalcEnumLogic(r.Context(), svcCtx)
		resp, err := l.CalcEnum()
		response.Response(w, resp, err)
	}
}
