package calc

import (
	"net/http"

	"oa-server/app/oacenter/oa_api/internal/logic/calc"
	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"
	"oa-server/response"

	"github.com/zeromicro/go-zero/rest/httpx"
)

func CalcHistoryListHandler(svcCtx *svc.ServiceContext) http.HandlerFunc {
	return func(w http.ResponseWriter, r *http.Request) {
		var req types.CalcHistoryListReq
		if err := httpx.Parse(r, &req); err != nil {
			response.Response(w, nil, err)
			return
		}

		l := calc.NewCalcHistoryListLogic(r.Context(), svcCtx)
		resp, err := l.CalcHistoryList(&req)
		response.Response(w, resp, err)
	}
}
