package calc

import (
	"net/http"

	"oa-server/app/oacenter/oa_api/internal/logic/calc"
	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"
	"oa-server/response"

	"github.com/zeromicro/go-zero/rest/httpx"
)

func CalcListHandler(svcCtx *svc.ServiceContext) http.HandlerFunc {
	return func(w http.ResponseWriter, r *http.Request) {
		var req types.CalcListReq
		if err := httpx.Parse(r, &req); err != nil {
			response.Response(w, nil, err)
			return
		}

		l := calc.NewCalcListLogic(r.Context(), svcCtx)
		resp, err := l.CalcList(&req)
		response.Response(w, resp, err)
	}
}
