package issue

import (
	"net/http"

	"oa-server/app/oacenter/oa_api/internal/logic/issue"
	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"
	"oa-server/response"

	"github.com/zeromicro/go-zero/rest/httpx"
)

func DepartmentChartDataHandler(svcCtx *svc.ServiceContext) http.HandlerFunc {
	return func(w http.ResponseWriter, r *http.Request) {
		var req types.MonitorChartDataReq
		if err := httpx.Parse(r, &req); err != nil {
			response.Response(w, nil, err)
			return
		}

		l := issue.NewDepartmentChartDataLogic(r.Context(), svcCtx)
		resp, err := l.DepartmentChartData(&req)
		response.Response(w, resp, err)

	}
}
