package issue

import (
	"net/http"

	"oa-server/app/oacenter/oa_api/internal/logic/issue"
	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"
	"oa-server/response"

	"github.com/zeromicro/go-zero/rest/httpx"
)

func DepartmentMetricsListHandler(svcCtx *svc.ServiceContext) http.HandlerFunc {
	return func(w http.ResponseWriter, r *http.Request) {
		var req types.IssueListReq
		if err := httpx.Parse(r, &req); err != nil {
			response.Response(w, nil, err)
			return
		}

		l := issue.NewDepartmentMetricsListLogic(r.Context(), svcCtx)
		resp, err := l.DepartmentMetricsList(&req)
		response.Response(w, resp, err)
	}
}
