package issue

import (
	"net/http"

	"oa-server/app/oacenter/oa_api/internal/logic/issue"
	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"
	"oa-server/response"

	"github.com/zeromicro/go-zero/rest/httpx"
)

func PersonalMetricsHandler(svcCtx *svc.ServiceContext) http.HandlerFunc {
	return func(w http.ResponseWriter, r *http.Request) {
		var req types.IssuePersonalMetricsReq
		if err := httpx.Parse(r, &req); err != nil {
			response.Response(w, nil, err)
			return
		}

		l := issue.NewPersonalMetricsLogic(r.Context(), svcCtx)
		resp, err := l.PersonalMetrics(&req)
		response.Response(w, resp, err)
	}
}
