package monitor

import (
	"net/http"
	"oa-server/response"

	"github.com/zeromicro/go-zero/rest/httpx"
	"oa-server/app/oacenter/oa_api/internal/logic/monitor"
	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"
)

func MonitorChartDataHandler(svcCtx *svc.ServiceContext) http.HandlerFunc {
	return func(w http.ResponseWriter, r *http.Request) {
		var req types.MonitorChartDataReq
		if err := httpx.Parse(r, &req); err != nil {
			response.Response(w, nil, err)
			return
		}

		l := monitor.NewMonitorChartDataLogic(r.Context(), svcCtx)
		resp, err := l.MonitorChartData(&req)
		response.Response(w, resp, err)
	}
}
