package okr

import (
	"net/http"
	"oa-server/response"

	"github.com/zeromicro/go-zero/rest/httpx"
	"oa-server/app/oacenter/oa_api/internal/logic/okr"
	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"
)

func AssignAddHandler(svcCtx *svc.ServiceContext) http.HandlerFunc {
	return func(w http.ResponseWriter, r *http.Request) {
		var req types.AssignAddReq
		if err := httpx.Parse(r, &req); err != nil {
			response.Response(w, nil, err)
			return
		}

		l := okr.NewAssignAddLogic(r.Context(), svcCtx)
		resp, err := l.AssignAdd(&req)
		response.Response(w, resp, err)
	}
}
