package okr

import (
	"net/http"

	"oa-server/app/oacenter/oa_api/internal/logic/okr"
	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"
	"oa-server/response"

	"github.com/zeromicro/go-zero/rest/httpx"
)

func DeleteKeyResultHandler(svcCtx *svc.ServiceContext) http.HandlerFunc {
	return func(w http.ResponseWriter, r *http.Request) {
		var req types.DeleteKeyResultReq
		if err := httpx.Parse(r, &req); err != nil {
			response.Response(w, nil, err)
			return
		}

		l := okr.NewDeleteKeyResultLogic(r.Context(), svcCtx)
		resp, err := l.DeleteKeyResult(&req)
		if err != nil {
			response.Error(w, err)
			return
		}
		response.Success(w, resp)
	}
}
