package okr

import (
	"net/http"
	"oa-server/response"

	"oa-server/app/oacenter/oa_api/internal/logic/okr"
	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"

	"github.com/zeromicro/go-zero/rest/httpx"
)

func DeleteObjectiveHandler(svcCtx *svc.ServiceContext) http.HandlerFunc {
	return func(w http.ResponseWriter, r *http.Request) {
		var req types.DeleteObjectiveReq
		if err := httpx.Parse(r, &req); err != nil {
			response.Response(w, nil, err)
			return
		}

		l := okr.NewDeleteObjectiveLogic(r.Context(), svcCtx)
		resp, err := l.DeleteObjective(&req)
		if err != nil {
			response.Error(w, err)
			return
		}
		response.Success(w, resp)
	}
}
