package okr

import (
	"net/http"
	"oa-server/response"

	"oa-server/app/oacenter/oa_api/internal/logic/okr"
	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"

	"github.com/zeromicro/go-zero/rest/httpx"
)

func MessageAssignHandleHandler(svcCtx *svc.ServiceContext) http.HandlerFunc {
	return func(w http.ResponseWriter, r *http.Request) {
		var req types.MessageAssignHandleReq
		if err := httpx.Parse(r, &req); err != nil {
			response.Response(w, nil, err)
			return
		}

		l := okr.NewMessageAssignHandleLogic(r.Context(), svcCtx)
		resp, err := l.MessageAssignHandle(&req)
		response.Response(w, resp, err)
	}
}
