package okr

import (
	"net/http"

	"oa-server/app/oacenter/oa_api/internal/logic/okr"
	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"
	"oa-server/response"

	"github.com/zeromicro/go-zero/rest/httpx"
)

func OkrApplyAckHandler(svcCtx *svc.ServiceContext) http.HandlerFunc {
	return func(w http.ResponseWriter, r *http.Request) {
		var req types.OkrApplyAckReq
		if err := httpx.Parse(r, &req); err != nil {
			response.Response(w, nil, err)
			return
		}

		l := okr.NewOkrApplyAckLogic(r.Context(), svcCtx)
		resp, err := l.OkrApplyAck(&req)
		response.Response(w, resp, err)
	}
}
