package okr

import (
	"net/http"

	"oa-server/app/oacenter/oa_api/internal/logic/okr"
	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"
	"oa-server/response"

	"github.com/zeromicro/go-zero/rest/httpx"
)

func UpdateKeyResultHandler(svcCtx *svc.ServiceContext) http.HandlerFunc {
	return func(w http.ResponseWriter, r *http.Request) {
		var req types.UpdateKeyResultReq
		if err := httpx.Parse(r, &req); err != nil {
			response.Response(w, nil, err)
			return
		}

		l := okr.NewUpdateKeyResultLogic(r.Context(), svcCtx)
		resp, err := l.UpdateKeyResult(&req)
		if err != nil {
			response.Error(w, err)
			return
		}
		response.Success(w, resp)
	}
}
