package performance

import (
	"net/http"

	"github.com/zeromicro/go-zero/rest/httpx"
	"oa-server/app/oacenter/oa_api/internal/logic/performance"
	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"
)

func GetPerformanceMenuDataHandler(svcCtx *svc.ServiceContext) http.HandlerFunc {
	return func(w http.ResponseWriter, r *http.Request) {
		var req types.GetPerformanceMenuDataReq
		if err := httpx.Parse(r, &req); err != nil {
			httpx.ErrorCtx(r.Context(), w, err)
			return
		}

		l := performance.NewGetPerformanceMenuDataLogic(r.Context(), svcCtx)
		resp, err := l.GetPerformanceMenuData(&req)
		if err != nil {
			httpx.ErrorCtx(r.Context(), w, err)
		} else {
			httpx.OkJsonCtx(r.Context(), w, resp)
		}
	}
}
