package performance

import (
	"net/http"

	"oa-server/app/oacenter/oa_api/internal/logic/performance"
	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"
	"oa-server/response"

	"github.com/zeromicro/go-zero/rest/httpx"
)

func GetStaffPerformanceListHandler(svcCtx *svc.ServiceContext) http.HandlerFunc {
	return func(w http.ResponseWriter, r *http.Request) {
		var req types.GetStaffPerformanceListReq
		if err := httpx.Parse(r, &req); err != nil {
			httpx.ErrorCtx(r.Context(), w, err)
			return
		}

		l := performance.NewGetStaffPerformanceListLogic(r.Context(), svcCtx)
		resp, err := l.GetStaffPerformanceList(&req)
		if err != nil {
			response.Error(w, err)
			return
		}
		response.Success(w, resp)
	}
}
