package public

import (
	"net/http"
	"oa-server/response"

	"oa-server/app/oacenter/oa_api/internal/logic/public"
	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"

	"github.com/zeromicro/go-zero/rest/httpx"
)

func CreateMonitorMetricsHandler(svcCtx *svc.ServiceContext) http.HandlerFunc {
	return func(w http.ResponseWriter, r *http.Request) {
		var req types.CreateMonitorMetricsReq
		if err := httpx.Parse(r, &req); err != nil {
			response.Response(w, nil, err)
			return
		}

		l := public.NewCreateMonitorMetricsLogic(r.Context(), svcCtx)
		err := l.CreateMonitorMetrics(&req)
		response.Response(w, nil, err)

	}
}
