package report

import (
	"net/http"

	"oa-server/app/oacenter/oa_api/internal/logic/report"
	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"
	"oa-server/response"

	"github.com/zeromicro/go-zero/rest/httpx"
)

func UpdateReportHandler(svcCtx *svc.ServiceContext) http.HandlerFunc {
	return func(w http.ResponseWriter, r *http.Request) {
		var req types.UpdateReportReq
		if err := httpx.Parse(r, &req); err != nil {
			httpx.ErrorCtx(r.Context(), w, err)
			return
		}

		l := report.NewUpdateReportLogic(r.Context(), svcCtx)
		resp, err := l.UpdateReport(&req)
		if err != nil {
			response.Error(w, err)
			return
		}
		response.Success(w, resp)
	}
}
