// Code generated by goctl. DO NOT EDIT.
// goctl 1.8.1

package handler

import (
	"net/http"

	calc "oa-server/app/oacenter/oa_api/internal/handler/calc"
	issue "oa-server/app/oacenter/oa_api/internal/handler/issue"
	monitor "oa-server/app/oacenter/oa_api/internal/handler/monitor"
	okr "oa-server/app/oacenter/oa_api/internal/handler/okr"
	performance "oa-server/app/oacenter/oa_api/internal/handler/performance"
	public "oa-server/app/oacenter/oa_api/internal/handler/public"
	report "oa-server/app/oacenter/oa_api/internal/handler/report"
	user "oa-server/app/oacenter/oa_api/internal/handler/user"
	"oa-server/app/oacenter/oa_api/internal/svc"

	"github.com/zeromicro/go-zero/rest"
)

func RegisterHandlers(server *rest.Server, serverCtx *svc.ServiceContext) {
	server.AddRoutes(
		rest.WithMiddlewares(
			[]rest.Middleware{serverCtx.AuthMiddleware},
			[]rest.Route{
				{
					Method:  http.MethodGet,
					Path:    "/calc/enum",
					Handler: calc.CalcEnumHandler(serverCtx),
				},
				{
					Method:  http.MethodPost,
					Path:    "/calc/historyList",
					Handler: calc.CalcHistoryListHandler(serverCtx),
				},
				{
					Method:  http.MethodPost,
					Path:    "/calc/list",
					Handler: calc.CalcListHandler(serverCtx),
				},
				{
					Method:  http.MethodPost,
					Path:    "/calc/modifyFormula",
					Handler: calc.ModifyCalcFormulaHandler(serverCtx),
				},
			}...,
		),
		rest.WithPrefix("/oacenter/v1"),
	)

	server.AddRoutes(
		rest.WithMiddlewares(
			[]rest.Middleware{serverCtx.AuthMiddleware},
			[]rest.Route{
				{
					Method:  http.MethodPost,
					Path:    "/issue/chartData",
					Handler: issue.DepartmentChartDataHandler(serverCtx),
				},
				{
					Method:  http.MethodPost,
					Path:    "/issue/metricsList",
					Handler: issue.DepartmentMetricsListHandler(serverCtx),
				},
				{
					Method:  http.MethodPost,
					Path:    "/issue/personalChartData",
					Handler: issue.PersonalChartDataHandler(serverCtx),
				},
				{
					Method:  http.MethodPost,
					Path:    "/issue/personalMetrics",
					Handler: issue.PersonalMetricsHandler(serverCtx),
				},
			}...,
		),
		rest.WithPrefix("/oacenter/v1"),
	)

	server.AddRoutes(
		rest.WithMiddlewares(
			[]rest.Middleware{serverCtx.AuthMiddleware},
			[]rest.Route{
				{
					Method:  http.MethodPost,
					Path:    "/monitor/chartData",
					Handler: monitor.MonitorChartDataHandler(serverCtx),
				},
				{
					Method:  http.MethodPost,
					Path:    "/monitor/metricsList",
					Handler: monitor.MonitorMetricsListHandler(serverCtx),
				},
				{
					Method:  http.MethodPost,
					Path:    "/monitor/personalChartData",
					Handler: monitor.PersonalChartDataHandler(serverCtx),
				},
				{
					Method:  http.MethodPost,
					Path:    "/monitor/personalMetrics",
					Handler: monitor.PersonalMetricsHandler(serverCtx),
				},
			}...,
		),
		rest.WithPrefix("/oacenter/v1"),
	)

	server.AddRoutes(
		rest.WithMiddlewares(
			[]rest.Middleware{serverCtx.AuthMiddleware},
			[]rest.Route{
				{
					Method:  http.MethodPost,
					Path:    "/keyresult/add",
					Handler: okr.CreateKeyResultHandler(serverCtx),
				},
				{
					Method:  http.MethodPost,
					Path:    "/keyresult/delete",
					Handler: okr.DeleteKeyResultHandler(serverCtx),
				},
				{
					Method:  http.MethodPost,
					Path:    "/keyresult/update",
					Handler: okr.UpdateKeyResultHandler(serverCtx),
				},
				{
					Method:  http.MethodGet,
					Path:    "/menu-data",
					Handler: okr.GetOkrMenuDataHandler(serverCtx),
				},
			}...,
		),
		rest.WithPrefix("/oacenter/v1/okr"),
	)

	server.AddRoutes(
		rest.WithMiddlewares(
			[]rest.Middleware{serverCtx.AuthMiddleware},
			[]rest.Route{
				{
					Method:  http.MethodPost,
					Path:    "/ack",
					Handler: okr.OkrAckHandler(serverCtx),
				},
				{
					Method:  http.MethodPost,
					Path:    "/applyAck",
					Handler: okr.OkrApplyAckHandler(serverCtx),
				},
				{
					Method:  http.MethodPost,
					Path:    "/messages",
					Handler: okr.MessageListHandler(serverCtx),
				},
				{
					Method:  http.MethodPost,
					Path:    "/suggestModify",
					Handler: okr.OkrSuggestModifyHandler(serverCtx),
				},
				{
					Method:  http.MethodPost,
					Path:    "/task/add",
					Handler: okr.OkrTaskAddHandler(serverCtx),
				},
				{
					Method:  http.MethodPost,
					Path:    "/task/delete",
					Handler: okr.OkrTaskDeleteHandler(serverCtx),
				},
				{
					Method:  http.MethodPost,
					Path:    "/task/update",
					Handler: okr.OkrTaskUpdateHandler(serverCtx),
				},
			}...,
		),
		rest.WithPrefix("/oacenter/v1/okr"),
	)

	server.AddRoutes(
		rest.WithMiddlewares(
			[]rest.Middleware{serverCtx.AuthMiddleware},
			[]rest.Route{
				{
					Method:  http.MethodPost,
					Path:    "/objective/add",
					Handler: okr.CreateObjectiveHandler(serverCtx),
				},
				{
					Method:  http.MethodPost,
					Path:    "/objective/delete",
					Handler: okr.DeleteObjectiveHandler(serverCtx),
				},
				{
					Method:  http.MethodPost,
					Path:    "/objective/update",
					Handler: okr.UpdateObjectiveHandler(serverCtx),
				},
			}...,
		),
		rest.WithPrefix("/oacenter/v1/okr"),
	)

	server.AddRoutes(
		rest.WithMiddlewares(
			[]rest.Middleware{serverCtx.AuthMiddleware},
			[]rest.Route{
				{
					Method:  http.MethodPost,
					Path:    "/message/read",
					Handler: okr.UpdateMessageStatusHandler(serverCtx),
				},
			}...,
		),
		rest.WithPrefix("/oacenter/v1/okr"),
	)

	server.AddRoutes(
		rest.WithMiddlewares(
			[]rest.Middleware{serverCtx.AuthMiddleware},
			[]rest.Route{
				{
					Method:  http.MethodPost,
					Path:    "/alignment/add",
					Handler: okr.AlignAddHandler(serverCtx),
				},
				{
					Method:  http.MethodPost,
					Path:    "/alignment/delete",
					Handler: okr.AlignDelHandler(serverCtx),
				},
				{
					Method:  http.MethodPost,
					Path:    "/assignment/add",
					Handler: okr.AssignAddHandler(serverCtx),
				},
				{
					Method:  http.MethodGet,
					Path:    "/detail",
					Handler: okr.OkrDetailHandler(serverCtx),
				},
				{
					Method:  http.MethodPost,
					Path:    "/message/alignment/handle",
					Handler: okr.MessageAlignHandleHandler(serverCtx),
				},
				{
					Method:  http.MethodPost,
					Path:    "/message/assignment/handle",
					Handler: okr.MessageAssignHandleHandler(serverCtx),
				},
				{
					Method:  http.MethodPost,
					Path:    "/pos",
					Handler: okr.OkrPosUpdateHandler(serverCtx),
				},
			}...,
		),
		rest.WithPrefix("/oacenter/v1/okr"),
	)

	server.AddRoutes(
		rest.WithMiddlewares(
			[]rest.Middleware{serverCtx.AuthMiddleware},
			[]rest.Route{
				{
					Method:  http.MethodPost,
					Path:    "/add",
					Handler: okr.CreateOkrHandler(serverCtx),
				},
			}...,
		),
		rest.WithPrefix("/oacenter/v1/okr"),
	)

	server.AddRoutes(
		rest.WithMiddlewares(
			[]rest.Middleware{serverCtx.AuthMiddleware},
			[]rest.Route{
				{
					Method:  http.MethodPost,
					Path:    "/add",
					Handler: performance.CreatePerformanceHandler(serverCtx),
				},
				{
					Method:  http.MethodPost,
					Path:    "/addition-item/update",
					Handler: performance.UpdatePerformanceAdditionItemHandler(serverCtx),
				},
				{
					Method:  http.MethodGet,
					Path:    "/addition-score",
					Handler: performance.GetPerformanceAdditionScoreListHandler(serverCtx),
				},
				{
					Method:  http.MethodPost,
					Path:    "/addition/score",
					Handler: performance.UpdatePerformanceAdditionScoreHandler(serverCtx),
				},
				{
					Method:  http.MethodPost,
					Path:    "/bonus/update",
					Handler: performance.UpdatePerformanceBonusHandler(serverCtx),
				},
				{
					Method:  http.MethodGet,
					Path:    "/detail",
					Handler: performance.GetPerformanceDetailHandler(serverCtx),
				},
				{
					Method:  http.MethodPost,
					Path:    "/inform",
					Handler: performance.InformPerformanceHandler(serverCtx),
				},
				{
					Method:  http.MethodPost,
					Path:    "/inform-performance",
					Handler: performance.InformToWritePerformanceHandler(serverCtx),
				},
				{
					Method:  http.MethodPost,
					Path:    "/item-comment/add",
					Handler: performance.CreatePerformanceItemCommentHandler(serverCtx),
				},
				{
					Method:  http.MethodPost,
					Path:    "/item-comment/delete",
					Handler: performance.DeletePerformanceItemCommentHandler(serverCtx),
				},
				{
					Method:  http.MethodGet,
					Path:    "/item-comment/list",
					Handler: performance.GetPerformanceItemCommentListHandler(serverCtx),
				},
				{
					Method:  http.MethodPost,
					Path:    "/item-comment/update",
					Handler: performance.UpdatePerformanceItemCommentHandler(serverCtx),
				},
				{
					Method:  http.MethodPost,
					Path:    "/items/done",
					Handler: performance.FinishPerformanceWorkloadFillingHandler(serverCtx),
				},
				{
					Method:  http.MethodPost,
					Path:    "/leader-ack",
					Handler: performance.PerformanceLeaderAckHandler(serverCtx),
				},
				{
					Method:  http.MethodPost,
					Path:    "/leader-evaluation/done",
					Handler: performance.FinishLeaderEvaluationHandler(serverCtx),
				},
				{
					Method:  http.MethodPost,
					Path:    "/leader-words",
					Handler: performance.LeaderWordsHandler(serverCtx),
				},
				{
					Method:  http.MethodGet,
					Path:    "/menu-data",
					Handler: performance.GetPerformanceMenuDataHandler(serverCtx),
				},
				{
					Method:  http.MethodGet,
					Path:    "/ranking",
					Handler: performance.GetPerformanceRankingHandler(serverCtx),
				},
				{
					Method:  http.MethodPost,
					Path:    "/rollback-status",
					Handler: performance.RollbackPerformanceStatusHandler(serverCtx),
				},
				{
					Method:  http.MethodGet,
					Path:    "/self",
					Handler: performance.GetPerformanceHandler(serverCtx),
				},
				{
					Method:  http.MethodPost,
					Path:    "/self-ack",
					Handler: performance.PerfomanceSelfAckHandler(serverCtx),
				},
				{
					Method:  http.MethodGet,
					Path:    "/staff",
					Handler: performance.GetStaffPerformanceHandler(serverCtx),
				},
				{
					Method:  http.MethodGet,
					Path:    "/staff-list",
					Handler: performance.GetStaffPerformanceListHandler(serverCtx),
				},
				{
					Method:  http.MethodPost,
					Path:    "/status/update",
					Handler: performance.UpdatePerformanceStatusUpdateHandler(serverCtx),
				},
				{
					Method:  http.MethodPost,
					Path:    "/work-item/add",
					Handler: performance.CreatePerformanceWorkItemHandler(serverCtx),
				},
				{
					Method:  http.MethodPost,
					Path:    "/work-item/delete",
					Handler: performance.DeletePerformanceWorkItemHandler(serverCtx),
				},
				{
					Method:  http.MethodPost,
					Path:    "/work-item/update",
					Handler: performance.UpdatePerformanceWorkItemHandler(serverCtx),
				},
			}...,
		),
		rest.WithPrefix("/oacenter/v1/performance"),
	)

	server.AddRoutes(
		[]rest.Route{
			{
				Method:  http.MethodPost,
				Path:    "/monitor/createMonitorMetrics",
				Handler: public.CreateMonitorMetricsHandler(serverCtx),
			},
		},
		rest.WithPrefix("/oacenter/v1"),
	)

	server.AddRoutes(
		[]rest.Route{
			{
				Method:  http.MethodPost,
				Path:    "/issue/createIssueMetrics",
				Handler: public.CreateIssueMetricsHandler(serverCtx),
			},
		},
		rest.WithPrefix("/oacenter/v1"),
	)

	server.AddRoutes(
		rest.WithMiddlewares(
			[]rest.Middleware{serverCtx.AuthMiddleware},
			[]rest.Route{
				{
					Method:  http.MethodPost,
					Path:    "/add",
					Handler: report.CreateReportHandler(serverCtx),
				},
				{
					Method:  http.MethodPost,
					Path:    "/comment/add",
					Handler: report.CreateReportCommentHandler(serverCtx),
				},
				{
					Method:  http.MethodGet,
					Path:    "/delay-risk-list",
					Handler: report.ListReportDelayAndRiskHandler(serverCtx),
				},
				{
					Method:  http.MethodGet,
					Path:    "/department-reports",
					Handler: report.ListDepartmentReportsHandler(serverCtx),
				},
				{
					Method:  http.MethodPost,
					Path:    "/inform-today-report",
					Handler: report.InformToWriteTodayReportHandler(serverCtx),
				},
				{
					Method:  http.MethodGet,
					Path:    "/list",
					Handler: report.ListReportHandler(serverCtx),
				},
				{
					Method:  http.MethodGet,
					Path:    "/mention-list",
					Handler: report.ListReportMentionHandler(serverCtx),
				},
				{
					Method:  http.MethodGet,
					Path:    "/statistics",
					Handler: report.GetReportStatisticsHandler(serverCtx),
				},
				{
					Method:  http.MethodPost,
					Path:    "/update",
					Handler: report.UpdateReportHandler(serverCtx),
				},
			}...,
		),
		rest.WithPrefix("/oacenter/v1/report"),
	)

	server.AddRoutes(
		rest.WithMiddlewares(
			[]rest.Middleware{serverCtx.AuthMiddleware},
			[]rest.Route{
				{
					Method:  http.MethodPost,
					Path:    "/user/department",
					Handler: user.DepartmentHandler(serverCtx),
				},
				{
					Method:  http.MethodPost,
					Path:    "/user/department-user-list",
					Handler: user.DepartmentUserListHandler(serverCtx),
				},
				{
					Method:  http.MethodPost,
					Path:    "/user/departmentList",
					Handler: user.DepartmentListHandler(serverCtx),
				},
				{
					Method:  http.MethodGet,
					Path:    "/user/follower",
					Handler: user.GetUserFollowerHandler(serverCtx),
				},
				{
					Method:  http.MethodPost,
					Path:    "/user/userList",
					Handler: user.UserListHandler(serverCtx),
				},
			}...,
		),
		rest.WithPrefix("/oacenter/v1"),
	)
}
