package user

import (
	"net/http"
	"oa-server/app/oacenter/oa_api/internal/logic/user"
	"oa-server/common/ctxdata"
	"oa-server/response"

	"github.com/zeromicro/go-zero/rest/httpx"
	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"
)

func DepartmentListHandler(svcCtx *svc.ServiceContext) http.HandlerFunc {
	return func(w http.ResponseWriter, r *http.Request) {
		var req types.DepartmentListReq
		if err := httpx.Parse(r, &req); err != nil {
			response.Response(w, nil, err)
			return
		}
		email := r.Context().Value(ctxdata.CtxKeyJwtUserEmail).(string)
		req.Employee = email
		l := user.NewDepartmentListLogic(r.Context(), svcCtx)
		resp, err := l.DepartmentList(&req)
		response.Response(w, resp, err)

	}
}
