package user

import (
	"net/http"

	"oa-server/app/oacenter/oa_api/internal/logic/user"
	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/response"
)

func GetUserFollowerHandler(svcCtx *svc.ServiceContext) http.HandlerFunc {
	return func(w http.ResponseWriter, r *http.Request) {
		l := user.NewGetUserFollowerLogic(r.Context(), svcCtx)
		resp, err := l.GetUserFollower()
		response.Response(w, resp, err)
	}
}
