package calc

import (
	"context"

	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"
	"oa-server/app/oacenter/oa_rpc/oa"
	"oa-server/common/constant"

	"github.com/zeromicro/go-zero/core/logx"
)

type CalcEnumLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewCalcEnumLogic(ctx context.Context, svcCtx *svc.ServiceContext) *CalcEnumLogic {
	return &CalcEnumLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *CalcEnumLogic) CalcEnum() (resp *types.CalcEnumResp, err error) {

	return &types.CalcEnumResp{
		Role: []types.Item{
			{
				Key:   oa.Role_DEVELOPER,
				Value: "开发",
			},
			{
				Key:   oa.Role_TEST,
				Value: "测试",
			},
		},
		Index: []types.Item{
			{
				Key:   oa.CalcIndex_MONITOR_SCORE,
				Value: "服务治理绩效评分",
			},
			{
				Key:   oa.CalcIndex_DELIVERY_QUALITY,
				Value: "交付质量评分",
			},
			// {
			// 	Key:   oa.CalcIndex_WORKLOAD,
			// 	Value: "工作量评分",
			// },
		},
		IssueIndex: []types.Item{
			{
				Key:   constant.ProdBugCount,
				Value: "生产缺陷数",
			},
			{
				Key:   constant.NonProdBugCount,
				Value: "非生产缺陷数",
			},
			{
				Key:   constant.BugEscapeRate,
				Value: "缺陷逃逸率",
			},
		},
		MonitorIndex: []types.Item{
			{
				Key:   constant.FailureRecurrenceRate,
				Value: "故障复发率",
			},
			{
				Key:   constant.AverageResponseTime,
				Value: "平均响应时间",
			},
			{
				Key:   constant.AverageProcessingTime,
				Value: "平均处理时间",
			},
			{
				Key:   constant.EffectiveHandledEvents,
				Value: "有效处理事件",
			},
			{
				Key:   constant.BizEventAssignmentRate,
				Value: "事件分配率",
			},
			{
				Key:   constant.BizRuleHitRate,
				Value: "规则命中率",
			},
		},
	}, nil
}
