package calc

import (
	"context"

	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"
	"oa-server/app/oacenter/oa_rpc/oa"

	"github.com/zeromicro/go-zero/core/logx"
)

type CalcHistoryListLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewCalcHistoryListLogic(ctx context.Context, svcCtx *svc.ServiceContext) *CalcHistoryListLogic {
	return &CalcHistoryListLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *CalcHistoryListLogic) CalcHistoryList(req *types.CalcHistoryListReq) (resp *types.CalcHistoryListResp, err error) {
	rpcResp, err := l.svcCtx.CalcRpc.CalcHistoryList(l.ctx, &oa.CalcHistoryListReq{
		PageNum:  int64(req.Page),
		PageSize: int64(req.PageSize),
		Id:       int64(req.ID),
	})
	if err != nil {
		logx.Errorw("CalcHistoryList failed", logx.Field("error", err))
		return nil, err
	}

	return &types.CalcHistoryListResp{
		Total: int(rpcResp.Total),
		List:  rpcResp.List,
	}, nil
}
