package calc

import (
	"context"

	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"
	"oa-server/app/oacenter/oa_rpc/oa"
	"oa-server/common/ctxdata"

	"github.com/zeromicro/go-zero/core/logx"
)

type CalcListLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewCalcListLogic(ctx context.Context, svcCtx *svc.ServiceContext) *CalcListLogic {
	return &CalcListLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *CalcListLogic) CalcList(req *types.CalcListReq) (resp *types.CalcListResp, err error) {
	userInfo := ctxdata.GetUserInfoFromCtx(l.ctx)

	rpcResp, err := l.svcCtx.CalcRpc.CalcList(l.ctx, &oa.CalcListReq{
		PageNum:             int64(req.Page),
		PageSize:            int64(req.PageSize),
		DepartmentKey:       req.DepartmentKey,
		ParentDepartmentKey: req.ParentDepartmentKey,
		Role:                oa.Role(req.Role),
		Index:               oa.CalcIndex(req.Index),
		Employee:            userInfo.Email,
	})
	if err != nil {
		logx.Errorw("CalcList failed", logx.Field("error", err))
		return nil, err
	}
	return &types.CalcListResp{
		List:  rpcResp.List,
		Total: int(rpcResp.Total),
	}, nil
}
