package calc

import (
	"context"

	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"
	"oa-server/app/oacenter/oa_rpc/oa"
	"oa-server/common/ctxdata"

	"github.com/zeromicro/go-zero/core/logx"
)

type ModifyCalcFormulaLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewModifyCalcFormulaLogic(ctx context.Context, svcCtx *svc.ServiceContext) *ModifyCalcFormulaLogic {
	return &ModifyCalcFormulaLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *ModifyCalcFormulaLogic) ModifyCalcFormula(req *types.ModifyCalcFormulaReq) (resp *types.BaseResp, err error) {
	reqID := make([]int64, 0)
	for _, v := range req.ID {
		reqID = append(reqID, int64(v))
	}

	calcFormula := make([]*oa.Item, 0)
	for _, v := range req.CalcFormula {
		calcFormula = append(calcFormula, &oa.Item{
			Key:   v.Key,
			Value: v.Value,
		})
	}
	_, err = l.svcCtx.CalcRpc.ModifyCalcFormula(l.ctx, &oa.ModifyCalcFormulaReq{
		Id:            reqID,
		CalcFormula:   calcFormula,
		EffectiveTime: req.EffectiveTime,
		Operator:      ctxdata.GetUserInfoFromCtx(l.ctx).Email,
	})
	if err != nil {
		logx.Errorw("ModifyCalcFormula failed", logx.Field("error", err))
		return nil, err
	}
	return &types.BaseResp{
		Code: 200,
		Msg:  "success",
	}, nil
}
