package issue

import (
	"context"

	"oa-server/app/oacenter/oa_api/internal/logic/common"
	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"
	"oa-server/app/oacenter/oa_rpc/oa"

	"github.com/zeromicro/go-zero/core/logx"
)

type DepartmentChartDataLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewDepartmentChartDataLogic(ctx context.Context, svcCtx *svc.ServiceContext) *DepartmentChartDataLogic {
	return &DepartmentChartDataLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *DepartmentChartDataLogic) DepartmentChartData(req *types.MonitorChartDataReq) (resp *types.MonitorChartDataResp, err error) {
	chartData, err := l.svcCtx.IssueRpc.DepartmentChartData(l.ctx, &oa.MetricsListReq{
		PeriodType:    oa.PeriodType(req.PeriodType),
		DepartmentKey: req.DepartmentKey,
		DateFromTo:    req.DateFromTo,
		Employee:      &req.Employee,
		Page:          int32(req.Page),
		PageSize:      int32(req.PageSize),
	})
	if err != nil {
		return nil, err
	}
	// 初始化响应
	resp = &types.MonitorChartDataResp{}

	// 处理不同类型的图表数据
	if chartData.RadarData != nil {
		resp.RadarData = common.ConvertRadarChartData(chartData.RadarData)
	}

	if chartData.LineBarData != nil {
		resp.BarData = common.ConvertLineBarChartData(chartData.LineBarData, "bar")
	}
	if chartData.LineBarData != nil {
		resp.LineData = common.ConvertLineBarChartData(chartData.LineBarData, "line")
	}

	if chartData.HeatmapData != nil {
		resp.HeatmapData = common.ConvertHeatmapChartData(chartData.HeatmapData)
	}

	return resp, nil
}
