package issue

import (
	"context"
	"fmt"

	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"
	"oa-server/app/oacenter/oa_rpc/oa"

	"github.com/zeromicro/go-zero/core/logx"
)

type PersonalChartDataLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewPersonalChartDataLogic(ctx context.Context, svcCtx *svc.ServiceContext) *PersonalChartDataLogic {
	return &PersonalChartDataLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *PersonalChartDataLogic) PersonalChartData(req *types.PersonalChartDataReq) (resp *types.MonitorChartDataResp, err error) {
	chartType := oa.ChartType(req.ChartType)
	rpcResp, err := l.svcCtx.IssueRpc.PersonalChartData(l.ctx, &oa.PersonalMetricsReq{
		PeriodType: oa.PeriodType(req.PeriodType),
		DateFromTo: req.DateFromTo,
		Employee:   &req.Employee,
		ChartType:  &chartType,
	})
	if err != nil {
		logx.Errorw("获取个人issue指标失败", logx.Field("error", err), logx.Field("employee", req.Employee))
		return nil, fmt.Errorf("获取个人issue指标失败: %v", err)
	}

	resp = &types.MonitorChartDataResp{
		RadarData: rpcResp.RadarData,
		LineData:  rpcResp.LineBarData,
	}

	return resp, nil
}
