package monitor

import (
	"context"
	"oa-server/app/oacenter/oa_api/internal/logic/common"
	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"
	"oa-server/app/oacenter/oa_rpc/client/monitorrpc"
	"oa-server/app/oacenter/oa_rpc/oa"

	"github.com/zeromicro/go-zero/core/logx"
)

type MonitorChartDataLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewMonitorChartDataLogic(ctx context.Context, svcCtx *svc.ServiceContext) *MonitorChartDataLogic {
	return &MonitorChartDataLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *MonitorChartDataLogic) MonitorChartData(req *types.MonitorChartDataReq) (resp *types.MonitorChartDataResp, err error) {
	rpcReq := &monitorrpc.MetricsListReq{
		Page:          int32(req.Page),
		PageSize:      int32(req.PageSize),
		DepartmentKey: req.DepartmentKey,
		DateFromTo:    req.DateFromTo,
		PeriodType:    oa.PeriodType(req.PeriodType),
	}

	// 添加可选参数
	if req.Employee != "" {
		rpcReq.Employee = &req.Employee
	}

	// 调用RPC服务
	chartData, err := l.svcCtx.MonitorRpc.GetMonitorChartData(l.ctx, rpcReq)
	if err != nil {
		return nil, err
	}

	// 初始化响应
	resp = &types.MonitorChartDataResp{}

	// 处理不同类型的图表数据
	if chartData.RadarData != nil {
		resp.RadarData = common.ConvertRadarChartData(chartData.RadarData)
	}

	if chartData.LineBarData != nil {
		resp.BarData = common.ConvertLineBarChartData(chartData.LineBarData, "bar")
	}
	if chartData.LineBarData != nil {
		resp.LineData = common.ConvertLineBarChartData(chartData.LineBarData, "line")
	}

	if chartData.HeatmapData != nil {
		resp.HeatmapData = common.ConvertHeatmapChartData(chartData.HeatmapData)
	}

	return resp, nil

}
