package monitor

import (
	"context"
	"oa-server/app/oacenter/oa_rpc/oa"

	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"

	"github.com/zeromicro/go-zero/core/logx"
)

type PersonalChartDataLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewPersonalChartDataLogic(ctx context.Context, svcCtx *svc.ServiceContext) *PersonalChartDataLogic {
	return &PersonalChartDataLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *PersonalChartDataLogic) PersonalChartData(req *types.PersonalChartDataReq) (resp *types.MonitorChartDataResp, err error) {

	rpcReq := &oa.PersonalMetricsReq{
		PeriodType: oa.PeriodType(req.PeriodType),
		DateFromTo: req.DateFromTo,
	}

	// 可选参数处理
	if req.Employee != "" {
		rpcReq.Employee = &req.Employee
	}

	if req.ChartType != 0 {
		chartType := oa.ChartType(req.ChartType)
		rpcReq.ChartType = &chartType
	}

	rpcResp, err := l.svcCtx.MonitorRpc.GetPersonalChartData(l.ctx, rpcReq)

	if err != nil {
		return nil, err
	}

	resp = &types.MonitorChartDataResp{
		RadarData: rpcResp.RadarData,
		LineData:  rpcResp.LineBarData,
	}
	return
}
